% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{mt_reshape}
\alias{mt_reshape}
\title{General-purpose reshape and aggregation function for mousetrap data.}
\usage{
mt_reshape(data, use = "trajectories", use_variables = NULL,
  use2 = "data", use2_variables = NULL, subset = NULL,
  subject_id = NULL, aggregate = FALSE, aggregate_subjects_only = FALSE,
  aggregation_function = mean, trajectories_long = TRUE,
  mt_seq = "mt_seq")
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import 
functions (see \link{mt_example} for details).}

\item{use}{a character string specifying which data should be reshaped. The
corresponding data are selected from data using \code{data[[use]]}. 
Usually, this value corresponds to either "trajectories",
"tn_trajectories", or "measures", depending on whether the analysis
concerns raw trajectories, time-normalized trajectories, or derived
measures.}

\item{use_variables}{a character vector specifying which mouse-tracking
variables should be reshaped. Corresponds to the column names in case a
data.frame with mouse-tracking measures is provided. Corresponds to the
labels of the array dimensions in case a trajectory array is provided. If
unspecified, all variables will be reshaped.}

\item{use2}{a character string specifying where the other trial data can be
found. Defaults to "data" as \code{data[["data"]]} usually contains all non
mouse-tracking trial data. Alternatively, a data.frame can be provided
directly.}

\item{use2_variables}{a character string (or vector) specifying the variables
(in \code{data[[use2]]}) that should be merged with the data. If
\code{aggregate==TRUE}, the trajectories / measures will be aggregated 
separately for each of the levels of these variables using
\link[reshape2]{dcast}.}

\item{subset}{a logical expression (passed on to \link{subset}) indicating
elements or rows to keep. If specified, \code{data[[use2]]} will be
subsetted using this expression, and, afterwards, \code{data[[use]]} will
be filtered accordingly.}

\item{subject_id}{a character string specifying which column contains the
subject identifier in \code{data[[use2]]}. If specified and
\code{aggregate==TRUE}, aggregation will be performed within subjects
first.}

\item{aggregate}{logical indicating whether data should be aggregated. If 
\code{use2_variables} are specified, aggregation will be performed 
separately for each of the levels of the \code{use2_variables}.}

\item{aggregate_subjects_only}{logical indicating whether data should only be
aggregated per subject (if \code{subject_id} is specified and
\code{aggregate==TRUE}).}

\item{aggregation_function}{the aggregation function passed on to
\link[reshape2]{dcast}. By default, the \link{mean} is calculated.}

\item{trajectories_long}{logical indicating if the reshaped trajectories 
should be returned in long or wide format. If \code{TRUE}, every recorded
position in a trajectory is placed in another row (whereby the order of the
positions is logged in \code{mt_seq}). If \code{FALSE}, every trajectory is
saved in wide format and the respective positions are indexed by adding an
integer to the corresponding label (e.g., \code{xpos_1},\code{xpos_2},
...). Only relevant if \code{data[[use]]} contains trajectories.}

\item{mt_seq}{a character string specifying the name of the column that will
contain the integers indicating the order of the mouse positions per
trajectory. Only relevant if \code{data[[use]]} contains trajectories and
\code{trajectories_long==TRUE}.}
}
\value{
A \link{data.frame} containing the reshaped data.
}
\description{
\code{mt_reshape} is the general function used in the \code{mousetrap} 
package for filtering, merging, reshaping, and aggregating mouse-tracking 
measures or trajectories in combination with other trial data. Several
additional (wrapper) functions for more specific purposes (cf. "See Also")
are available.
}
\details{
\code{mt_reshape} uses the \link{mt_id} variable for merging the trajectories
/ measures (in \code{data[[use]]}) and the trial data (in
\code{data[[use2]]}).

The main purpose of this function is to reshape the trajectory data into a 
two-dimensional data.frame, as this format is required for many further
analyses and plots in R.

Besides, it should aid the user in combining data contained in different
parts of the mousetrap data object, e.g., a condition variable stored in 
\code{data[["data"]]} with trajectory data stored in 
\code{data[["trajectories"]]} (or mouse-tracking measures stored in 
\code{data[["measures"]]}).

Finally, it offers the possibility to aggregate trajectories and measures for
different conditions and/or subjects.

The package also includes several functions that wrap \code{mt_reshape} and
serve specific purposes. They are often easier to use, and thus recommended
over \code{mt_reshape} unless the utmost flexibility is required. These
functions are described in the section "See Also".

Note also that many merging, reshaping, and aggregation procedures can be 
performed directly by using some of the basic R functions, e.g., \link{merge}
and \link{aggregate}, or through the R packages \code{reshape2} or 
\code{dplyr}, if desired.
}
\examples{
# Time-normalize trajectories
mt_example <- mt_time_normalize(mt_example)
  
# Reshape time-normalized trajectories data into long format
# adding Condition variable
trajectories_long <- mt_reshape(mt_example, 
 use="tn_trajectories",
 use2_variables="Condition"
 )
                                
# Reshape time-normalized trajectories data into wide format
# only keeping xpos and ypos
# and adding Condition variable
trajectories_wide <- mt_reshape(mt_example,
  use="tn_trajectories", use_variables = c("xpos","ypos"),
  use2_variables = "Condition",
  trajectories_long = FALSE
  )
  
}
\seealso{
\link{mt_aggregate} for aggregating mouse-tracking measures and trajectories.

\link{mt_aggregate_per_subject} for aggregating mouse-tracking measures and
trajectories per subject.

\link{merge} for merging data in R.

\link{aggregate} for aggregating data in R.

\link[reshape2]{dcast} for reshaping and aggregating data using the
\code{reshape2} package.

Regarding the dangers of using \code{mt_reshape}, please consider the
following limerick before applying the function:
}

