% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviations.R
\name{mt_calculate_deviations}
\alias{mt_calculate_deviations}
\title{Calculate deviations from idealized trajectory.}
\usage{
mt_calculate_deviations(data, use = "trajectories", save_as = use,
  start_ideal = NULL, end_ideal = NULL, prefix = "",
  show_progress = TRUE)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import 
functions (see \link{mt_example} for details). Alternatively, a trajectory 
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be 
used.}

\item{save_as}{a character string specifying where the resulting trajectory 
data should be stored.}

\item{start_ideal}{an optional vector specifying the start position (see
Example). If specified, this position will be used as the starting point of
the idealized trajectory (instead of the actual starting point).}

\item{end_ideal}{an optional vector specifying the end position (see
Example). If specified, this position will be used as the end point of the
idealized trajectory (instead of the actual end point).}

\item{prefix}{an optional character string that is added as a prefix to the 
to be created new trajectory dimensions.}

\item{show_progress}{logical indicating whether function should report on its
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}) with the x- and
  y-positions of the idealized trajectory and the perpendicular deviations of
  the actual trajectory from it added as additional columns to the trajectory
  array. If the trajectory array was provided directly as \code{data}, only
  the trajectory array will be returned.
}
\description{
Calculate the idealized trajectory and the perpendicular deviations of the
actual trajectory from it for each logged position.
}
\details{
The idealized trajectory is defined as the straight line connecting the start
and end point of the actual trajectory (e.g., Freeman & Ambady, 2010). The 
deviation for each position is calclated as the perpendicular deviation of 
the actual trajectory from the idealized trajectory.

If a deviation occurs above the direct path, this is denoted by a positive
value. If it occurs below the direct path, this is denoted by a negative
value. This assumes that the complete movement in the trial was from bottom
to top (i.e., the end point has a higher y-position than the start point). In
case the movement was from top to bottom, \code{mt_calculate_deviations}
automatically flips the signs.
}
\examples{
# Calculate deviations from idealized trajectory
# (straight line connecting the start and end point of each trial)
mt_example <- mt_calculate_deviations(mt_example)
  
# Calculate deviations from idealized trajectory with
# constant start and end points across trials
mt_example <- mt_calculate_deviations(mt_example,
  start_ideal=c(xpos=0,ypos=0), end_ideal=c(xpos=-665,ypos=974))

}
\references{
Freeman, J. B., & Ambady, N. (2010). MouseTracker: Software for
  studying real-time mental processing using a computer mouse-tracking
  method. \emph{Behavior Research Methods, 42}(1), 226-241.
}
\seealso{
\link{mt_calculate_measures} for calculating per-trial
  mouse-tracking measures.
}

