% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{merge_splice}
\alias{merge_splice}
\title{Merge splices together using set operations}
\usage{
merge_splice(..., operation)
}
\arguments{
\item{...}{a collection of named \code{Splice} objects.}

\item{operation}{either 'union' or 'intersection'.}
}
\value{
a \code{Splice} object.
}
\description{
Merge splices together using set operations
}
\examples{
l1 <- list(a1 = c(100, 200), a2 = c(250, 300), a3 = c(400, 550), a4 = c(600, 650))
split1_dfr <- splice_time(l1)
split1_dfr

l2 <- list(b1 = c(150, 275), b2 = c(610, 640))
split2_dfr <- splice_time(l2)
split2_dfr

l3 <- list(c1 = c(275, 325), c2 = c(600, 675), c3 = c(700, 725))
split3_dfr <- splice_time(l3)
split3_dfr

merge_splice(x = split1_dfr, y = split2_dfr, z = split3_dfr, operation = 'union')
merge_splice(x = split1_dfr, y = split2_dfr, z = split3_dfr, operation = 'intersection')
}
\seealso{
Other splicing functions: 
\code{\link{clip_splice}()},
\code{\link{get_spliced_view}()},
\code{\link{is_splice_overlapping}()},
\code{\link{splice_time.Duration}()},
\code{\link{splice_time.Metre}()},
\code{\link{splice_time.OnsetsDifference}()},
\code{\link{splice_time.View}()},
\code{\link{splice_time.list}()},
\code{\link{splice_time}()},
\code{\link{split.SplicedView}()}
}
\concept{splicing functions}
