# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate the Normalizing Constant in log scale for COM-Poisson distribution
#'  
#' The calculation of the function \code{logZ} will be performed here. This function is 
#' used to approximate the normalizing constant for COM-Poisson distributions via 
#' truncation. The standard COM-Poisson parametrization is being used here. 
#' 
#' It is assumed that vectors log_lambda & nu are of equal length. 
#' 
#' This function was originally purposed in the \code{cmpreg} package of Ribeiro Jr, 
#' Zeviani & Demétrio (2019).
#' 
#' @param log_lambda rate parameter in log scale.
#' @param nu dispersion parameter, straightly positive.
#' @param summax maximum number of terms to be considered in the truncated sum.
#' @useDynLib mpcmp, .registration = TRUE
#' @importFrom Rcpp sourceCpp
#' @references 
#' Ribeiro Jr, E. E., Zeviani, W. M., Demétrio, C. G. B. (2019) \code{cmpreg}: 
#' Reparametrized COM-Poisson Regression Models. R package version 0.0.1.
#' @export
#' 
logZ_c <- function(log_lambda, nu, summax) {
    .Call(`_mpcmp_logZ_c`, log_lambda, nu, summax)
}

