% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_glm_cmp_const_nu.R
\name{fit_glm_cmp_const_nu}
\alias{fit_glm_cmp_const_nu}
\title{Fit a Mean Parametrized Conway-Maxwell Poisson Generalized Linear
Model with constant dispersion.}
\usage{
fit_glm_cmp_const_nu(
  y = y,
  X = X,
  offset = offset,
  betastart = betastart,
  lambdalb = lambdalb,
  lambdaub = lambdaub,
  maxlambdaiter = maxlambdaiter,
  tol = tol
)
}
\arguments{
\item{y}{the response y vector.}

\item{X}{the design matrix for regressing the mean}

\item{offset, }{this can be used to specify an \emph{a priori} known component to be included
in the linear predictor for mean during fitting. This should be \code{NULL} or a numeric vector}

\item{betastart}{starting values for the parameters in the linear predictor for mu.}

\item{lambdalb, lambdaub}{numeric: the lower and upper end points for the interval to be
searched for lambda(s). The default value for lambdaub should be sufficient for small to
moderate size nu. If nu is large and required a larger \code{lambdaub}, the algorithm
will scale up \code{lambdaub} accordingly.}

\item{maxlambdaiter}{numeric: the maximum number of iterations allowed to solve
for lambda(s).}

\item{tol}{numeric: the convergence threshold. A lambda is said to satisfy the
mean constraint if the absolute difference between the calculated mean and a fitted
values is less than tol.}
}
\value{
A fitted model object of class \code{cmp} similar to one obtained from \code{glm} or \code{glm.nb}.
}
\description{
This is a workhorse function in which glm.cmp to call upon to fit a
mean-parametrized Conway-Maxwell Poisson generalized linear model with
constant dispersion.
}
\examples{
## For examples see example(glm.cmp)

}
