% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/grobner.R
\name{grobner}
\alias{grobner}
\title{Compute a grobner basis of a list of multivariate polynomials.}
\usage{
grobner(mpolyList, varorder = vars(mpolyList), order = "lex")
}
\arguments{
\item{mpolyList}{an object of class mpolyList}

\item{varorder}{order of variables}

\item{order}{total order to be considered for monomials (e.g. lexicographic)}
}
\value{
An object of class mpolyList.
}
\description{
grobner computes a Groebner basis for a collection of multivarite polynomials
represented as an object of class mpolyList. Note that the polynomials
printed after calculation are unlikely to be properly ordered; this is
because the order of the monomials displayed is governed by the print method,
not the mpoly's themselves.
}
\examples{
\dontrun{
polys <- mp(c('t^4 - x', 't^3 - y', 't^2 - z'))
grobner(polys)
# result
# -1 z  +  t^2
# t y  -  z^2
# -1 y  +  t z
# x  -  z^2
# y^2  -  z^3

grobner(polys, varorder = c('x','y','t','z'))
# x  -  z^2
# y  -  z t
# -1 z  +  t^2

polys <- mp(c('x^2 - 2 y^2', 'x y - 3'))
grobner(polys, varorder = c('x', 'y'))
# result
# 3 x  -  2 y^3
# 2 y^4  -  9

# using a different monomial order
grobner(polys, varorder = c('x', 'y'), order = 'grlex')
# -3 x  +  2 y^3
# x^2  -  2 y^2
# -3  +  x y


# example from algebraic statistics, dinwoodie 1998
#mp()

}
}

