% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{predicates}
\alias{predicates}
\alias{is.constant}
\alias{is.mpoly}
\alias{is.bernstein}
\alias{is.bezier}
\alias{is.chebyshev}
\alias{is.mpolyList}
\alias{is.linear}
\title{mpoly predicate functions}
\usage{
is.constant(x)

is.mpoly(x)

is.bernstein(x)

is.bezier(x)

is.chebyshev(x)

is.mpolyList(x)

is.linear(x)
}
\arguments{
\item{x}{object to be tested}
}
\value{
Vector of logicals.
}
\description{
Various functions to deal with mpoly and mpolyList objects.
}
\examples{

p <- mp("5")
is.mpoly(p)
is.constant(p)

is.constant(mp(c("x + 1", "7", "y - 2")))

p <- mp("x + y")
is.mpoly(p)

is.mpolyList(mp(c("x + 1", "y - 1")))



is.linear(mp("0"))
is.linear(mp("x + 1"))
is.linear(mp("x + y"))
is.linear(mp(c("0", "x + y")))

is.linear(mp("x + x y"))
is.linear(mp(c("x + x y", "x")))


(p <- bernstein(2, 5))
is.mpoly(p)
is.bernstein(p)

(p <- chebyshev(5))
is.mpoly(p)
is.chebyshev(p)
str(p)
}
