% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mppGE_CIM.R
\name{mppGE_CIM}
\alias{mppGE_CIM}
\title{MPP GxE Composite Interval Mapping}
\usage{
mppGE_CIM(
  mppData,
  trait,
  VCOV = "UN",
  VCOV_data = "unique",
  cofactors = NULL,
  cof_red = FALSE,
  cof_pval_sign = 0.1,
  window = 20,
  ref_par = NULL,
  n.cores = 1,
  maxIter = 100,
  msMaxIter = 100
)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Character vector} specifying which traits (environments) should be used.}

\item{VCOV}{VCOV \code{Character} expression defining the type of variance
covariance structure used. 'CS' for compound symmetry assuming a unique
genetic covariance between environments. 'CSE' for cross-specific within
environment error term. 'CS_CSE' for both compound symmetry plus
cross-specific within environment error term. 'UN' for unstructured
environmental variance covariance structure allowing a specific genotypic
covariance for each pair of environments. Default = 'UN'}

\item{VCOV_data}{\code{Character} specifying if the reference VCOV should
be formed  taking all cofactors into consideration ("unique") or if different
VCOVs should be formed by removing the cofactor information that is too close
of a tested QTL position ("minus_cof"). Default = "unique"}

\item{cofactors}{Object of class \code{QTLlist} representing a list of
selected marker positions obtained with the function \code{QTL_select()} or
a vector of \code{character} marker positions names.
Default = NULL.}

\item{cof_red}{\code{Logical} value specifying if the cofactor matrix should
be reduced by only keeping the significant allele by environment interaction.
Default = FALSE}

\item{cof_pval_sign}{\code{Numeric} value specifying the p-value significance
of an allele by environment term to be kept in the model. Default = 0.1}

\item{window}{\code{Numeric} distance (cM) on the left and the right of a
cofactor position where it is not included in the model. Default = 20.}

\item{ref_par}{Optional \code{Character} expression defining the parental
allele that will be used as reference for the parental model. Default = NULL}

\item{n.cores}{\code{Numeric}. Specify here the number of cores you like to
use. Default = 1.}

\item{maxIter}{maximum number of iterations for the lme optimization algorithm.
Default = 100.}

\item{msMaxIter}{maximum number of iterations for the optimization step inside
the lme optimization. Default = 100.}
}
\value{
Return:

\item{CIM }{\code{Data.frame} of class \code{QTLprof}. with five columns :
1) QTL marker or in between position names; 2) chromosomes;
3) integer position indicators on the chromosome;
4) positions in centi-Morgan; and 5) -log10(p-val) of the global QTL effect
across environments 6) p-values of the within environment QTL effects
(one column per environment); and p-values of the within environment parental
QTL allelic effects (one column per parent environment combination).}
}
\description{
Computes multi-QTL models with cofactors along the genome using an approximate
mixed model computation. An initial variance covariance (VCOV) structure is
calculated using function from the \code{nlme} package. Then, this information
is used to estimate the QTL global and within parental effect significance using a
Wald test.
}
\details{
It is possible to calculate one initial VCOV using a null model with all
the cofactors (\code{VCOV_data = "unique"}) or one VCOV per combination of
cofactors (\code{VCOV_data = "minus_cof"}). In the later case, the cofactor
that fall witin a distance of \code{window} on the left and right of a QTL
position is removed for the calculation of the initial VCOV. Therefore,
N_cof + 1 VCOV are calculated.
}
\examples{

data(mppData_GE)

cofactors <- mppData_GE$map$mk.names[c(35, 61)]

CIM <- mppGE_CIM(mppData = mppData_GE, trait = c('DMY_CIAM', 'DMY_TUM'),
                     cofactors = cofactors, window = 20)
                     
Qpos <- QTL_select(CIM)
                      
plot(CIM)

plot_allele_eff_GE(mppData = mppData_GE, nEnv = 2, EnvNames = c('CIAM', 'TUM'),
                   Qprof = CIM, Q.eff = 'par', QTL = Qpos, text.size = 14)

}
\references{
Pinheiro J, Bates D, DebRoy S, Sarkar D, R Core Team (2021). nlme: Linear
and Nonlinear Mixed Effects Models_. R package version 3.1-152,
<URL: https://CRAN.R-project.org/package=nlme>.

\code{\link{mppGE_SIM}},
\code{\link{mppGE_proc}}
}
\author{
Vincent Garin
}
