% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matlist.R
\docType{methods}
\name{sigma}
\alias{sigma}
\alias{smat}
\alias{SIGMA}
\alias{smat,missing-method}
\alias{smat,matrix-method}
\alias{smat,list-method}
\alias{smat,sigmalist-method}
\alias{smat,mrgmod-method}
\alias{smat,NULL-method}
\alias{smat,mrgsims-method}
\title{Manipulate SIGMA matrices}
\usage{
smat(.x, ...)

\S4method{smat}{missing}(.x, ...)

\S4method{smat}{matrix}(.x, ..., labels = list())

\S4method{smat}{list}(.x, ...)

\S4method{smat}{sigmalist}(.x, ...)

\S4method{smat}{mrgmod}(.x, ..., make = FALSE, open = FALSE)

\S4method{smat}{`NULL`}(.x, ...)

\S4method{smat}{mrgsims}(.x, make = FALSE, ...)
}
\arguments{
\item{.x}{a matrix, list of matrices or \code{matlist} object}

\item{...}{passed to other functions, including \code{\link{modMATRIX}}}

\item{labels}{character vector of names for \code{$SIGMA} elements; must be equal 
to number of rows/columns in the matrix}

\item{make}{logical; if TRUE, matrix list is rendered into a single matrix}

\item{open}{passed to \code{\link{merge.list}}}

\item{x}{\code{matlist} object}
}
\description{
The primary function is \code{smat} that can be used to both get the 
\code{$SIGMA} matrices out of a model object and to update \code{$SIGMA} 
matrices in a model object.
}
\examples{
## example("sigma")
mat1 <- matrix(1)
mat2 <- diag(c(1,2))
mat3 <- matrix(c(0.1, 0.002, 0.002, 0.5), 2,2)
mat4 <- dmat(0.1, 0.2, 0.3, 0.4)

smat(mat1)
smat(mat1, mat2, mat3)
smat(A=mat1, B=mat2, C=mat3)

mod <- mrgsolve:::house() \%>\% smat(mat1)

smat(mod)
smat(mod, make=TRUE)
}
