% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chain.R
\docType{methods}
\name{Req}
\alias{Req}
\alias{Req,mrgmod-method}
\alias{req}
\alias{req,mrgmod-method}
\title{Request simulated output}
\usage{
Req(x, ...)

\S4method{Req}{mrgmod}(x, ...)

req(x, ...)

\S4method{req}{mrgmod}(x, ...)
}
\arguments{
\item{x}{model object}

\item{...}{unquoted names of compartments or tabled items}
}
\description{
Use this function to select, by name, either compartments or derived 
variables that have been captured (see \code{\link{CAPTURE}}) into
the simulated output.
}
\details{
There is also a \code{Req} argument to \code{\link{mrgsim}} that can 
be set to accomplish the same thing as a call to \code{Req} in 
the pipeline.

Note the difference between \code{req} and \code{Req}: the former only 
selects compartments to appear in output while the latter selects both 
compartments and captured items.  Also, when there are items are explicitly
listed in \code{Req}, all other compartments or captured items not listed
there are ignored.  But when compartments are selected with \code{req}
all of the captured items are returned.  Remember that \code{req} is 
strictly for compartments.
}
\examples{
mod <- mrgsolve:::house()

mod \%>\% Req(CP,RESP) \%>\% ev(amt=1000) \%>\%  mrgsim

}
