% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{createGrid}
\alias{createGrid}
\title{Create a grid of candidate designs}
\usage{
createGrid(
  p0,
  p1,
  alpha = 0.1,
  beta = NA,
  power = ifelse(is.na(beta), 0.9, 1 - beta),
  nMin = NA,
  nMax = NA,
  mander = TRUE
)
}
\arguments{
\item{p0}{the response rate under the null hypothesis}

\item{p1}{the response rate under the alternate hypothesis}

\item{alpha}{the desired (one-sided) type 1 error rate}

\item{beta}{the desired type 2 error rate}

\item{power}{an alternative to \code{beta}}

\item{nMin}{the lower bound for the search grid.  If \code{NA},
\code{searchBounds} is called to provide an appropriate value}

\item{nMax}{the lower bound for the search grid.  If \code{NA},
\code{searchBounds} is called to provide an appropriate value}

\item{mander}{is a Mander & Thompson or a Simon's design required?}
}
\value{
a tibble.  See Usage notes for a list and description of columns.
}
\description{
Create a grid of candidate designs
}
\examples{
# Standard use for a Simon's 2-stage design
x <- createGrid(p0 = 0.1, p1 = 0.5, alpha = 0.1, beta = 0.1, mander = FALSE)
# Custom search bounds for a Mander & Thompson design
y <- createGrid(p0 = 0.1, p1 = 0.4, alpha = 0.1, beta = 0.1, nMin = 20, nMax = 30)
}
