% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOptimalCentroids.R
\name{getOptimalCentroids}
\alias{getOptimalCentroids}
\title{getOptimalCentroids}
\usage{
getOptimalCentroids(
  x,
  iter.max,
  algorithm,
  nclust,
  distance_metric,
  error_metric,
  quant.err
)
}
\arguments{
\item{x}{Data Frame. A dataframe of multivariate data. Each row corresponds to an
observation, and each column corresponds to a variable. Missing values are
not accepted.}

\item{iter.max}{The max number of iterations the the getOptimalCentroid function will run
to get the optimal number of centroids}

\item{algorithm}{String. The type of algorithm used for quantization.
Available algorithms are Hartigan and Wong, "Lloyd", "Forgy", "MacQueen".
(default is "Hartigan-Wong")}

\item{nclust}{Numeric. Indicating the number of nodes per hierarchy.}

\item{distance_metric}{character. The distance metric can be 'L1_Norm" or "L2_Norm". L1_Norm is selected by default.}

\item{error_metric}{character. The error metric can be "mean" or "max". mean is selected by default}

\item{quant.err}{Numeric. The quantization error for the algorithm.}
}
\value{
\item{clusters}{ List. A list showing each ID assigned to a cluster.
} \item{nodes.clust}{ List. A list corresponding to nodes' details. }
\item{idnodes}{ List. A list of ID and segments similar to
\code{nodes.clust} with additional columns for nodes ID. }
\item{error.quant}{ List. A list of quantization error for all levels and
nodes. } \item{plt.clust}{ List. A list of logical values indicating if the
quantization error was met. } \item{summary}{ Summary. Output table with
summary. }
}
\description{
Get Optimal Centroids
}
\details{
The raw data is first scaled and this scaled data is supplied as input to
the vector quantization algorithm. Vector quantization technique uses a
parameter called quantization error. This parameter acts as a threshold and
determines the number of levels in the hierarchy. It means that, if there
are 'n' number of levels in the hierarchy, then all the clusters formed till
this level will have quantization error equal or greater than the threshold
quantization error. The user can define the number of clusters in the first
level of hierarchy and then each cluster in first level is sub-divided into
the same number of clusters as there are in the first level. This process
continues and each group is divided into smaller clusters as long as the
threshold quantization error is met. The output of this technique will be
hierarchically arranged vector quantized data.
}
\author{
Sangeet Moy Das <sangeet.das@mu-sigma.com>
}
