% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{as_col_spec}
\alias{as_col_spec}
\alias{as_parser}
\alias{parse_type}
\title{Describe column types for use in the columns table}
\usage{
as_col_spec(type_str)

as_parser(type_str)

parse_type(type_str)
}
\arguments{
\item{type_str}{A type string, one of date, datetime, logical, double, character, guess,
time, integer, wkt, or json.}
}
\value{
A parsed version of the type_str, a column specification or parsing function
}
\description{
Type descriptions are basically calls to \code{readr::col_*} or 
\code{readr::parse_*}, and can 
contain arguments for the sake of completeness (but this shouldn't normally be necessary).
}
\examples{
# mostly type specs are just type names
# parse_type("character")
# as_col_spec("character")
# as_parser("character")

# can also pass arguments if needed
# parse_type("datetime(format='\%m\%.\%d\%.\%Y')")
# as_col_spec("datetime(format='\%m\%.\%d\%.\%Y')")
# as_parser("datetime(format='\%m\%.\%d\%.\%Y')")

}
\keyword{internal}
