# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate Inplace a Series of Dot Product
#'
#' Calculate inplace \code{a_t-=b_t%*%c_t} where a, b, c are matrices,
#' t is index in time and %*% is a dot product.
#' The result is subtracted from a, so if a pure multiplication result is needed,
#' user must initialized a to 0 before call
#' @param b A sparse matrix (cf. \link[slam]{simple_triplet_matrix}) of size (nr_b*ntico, nc_b) given by its fields
#' v, i, and j describing triplet storage.
#' @param c A dense array, the size of c is (ldc, nc_c, ntico), ldc must be >= ncol(b)
#' @param a A dense array, the size of a is (nr_b, nc_c, ntico)
#' @return None
#' @export
mult_bxxc <- function(a, b, c) {
    invisible(.Call(`_multbxxc_mult_bxxc`, a, b, c))
}

#' Solve ODE System by Implicite Euler Scheme
#'
#' The system is defined as \eqn{M*dx/dt=a*x+s} where M is a diagonal
#' matrix given by its diagonal vector M (which has a form of matrix for
#' term-by-term multiplication with x0)
#' In discrete terms
#' \eqn{(M/dt_i-a)*x_i=(M/dt_i)*x_(i-1)+s_i}
#' The rmumps matrix \eqn{(M/dt_i-a)} is stored in list ali as XPtr<Rmumps>
#' or a plain dense inverted matrix.
#' Calculations are done in-place so s is modified and contains the
#' solution on exit. The others parameters are not modified.
#' @param invdt A numeric vactor, represents 1/dt
#' @param x0_ A numeric matrix or NULL, is the starting value at t0 (NULL means 0)
#' @param M A numeric matrix representing diagonal terms (masses)
#' @param ali A list of matrices or Rmumps objects
#' @param s A 3d numeric array, is the source term, its last margin corresponds to time. \code{s[,,i]} can be a matrix or a vector(== 1-column matrix) 
#' @param ilua An integer vector, \code{ilua[i]} gives the list index in \code{ali} for a given \eqn{dt_i}. In such a way, \code{ali} may be shorter than time points.
#' @return None
#' @export
solve_ieu <- function(invdt, x0_, M, ali, s, ilua) {
    invisible(.Call(`_multbxxc_solve_ieu`, invdt, x0_, M, ali, s, ilua))
}

#' Fast Match for Matrix Indexes
#'
#' Match ix,jx-couple in ti,tj-table and return their 1-based positions (0 for non matched couples)
#' @param ix An integer vector
#' @param jx An integer vector
#' @param ti An integer vector
#' @param tj An integer vector
#' @return An integer vector
#' @examples
#' match_ij(1:2, 1:2, 0:4, 0:4)
#' # [1] 2 3
#'
#' @export
match_ij <- function(ix, jx, ti, tj) {
    .Call(`_multbxxc_match_ij`, ix, jx, ti, tj)
}

#' Bloc Operation in Place
#' 
#' src array is added (if sop=="+=") to dst[...]
#' or any other manipulation is made according to sop parameter
#' Both arrays are supposed to be of type 'double'
#' The operation is done 'in place' without new memory allocation for dst
#' src is reshaped and possibly replicated to fit the designated block of dst.
#' mv can be: \itemize{
#'  \item a 1 or 3 component vector describing the block: 1-margin number of dst, 2-offset, 3-length
#'    if only the margin is present than offest is 0 and length is the total length of this margin
#'  \item a matrix of indexes. Its column number must be equal to the length(dim(dst)))
#'    each row of this matrix is a multidimensional index in dst array.
#' }
#' sop is one off: "=" (copy src to dst[]), "+=", "-=", "*=", "/="
#' @param dst A numeric array, destination
#' @param mv An integer vector or matrix, describe margins to operate on
#' @param sop A string, describes an operator to apply
#' @param src A numeric array, source (may be replicated to fit the size of dst)
#' @return None
#' @examples
#' a=matrix(1, 3, 3) # 3x3 matrix of 1's
#' b=1:3
#' bop(a, 2, "+=", b) # a += b, here b will be repeated
#' a
#' #      [,1] [,2] [,3]
#' # [1,]    2    2    2
#' # [2,]    3    3    3
#' # [3,]    4    4    4
#' @export
bop <- function(dst, mv, sop, src) {
    invisible(.Call(`_multbxxc_bop`, dst, mv, sop, src))
}

#' New Dimensions
#'
#' Write new dimension vector while keeping the old memory
#' @param x A numeric array
#' @param di An integer vector, new dimensions
#' @return None
#' @examples
#' a=matrix(as.double(1:12), 6, 2)
#' redim(a, c(3, 4))
#' dim(a)
#' # [1] 3 4
#' @export
redim <- function(x, di) {
    invisible(.Call(`_multbxxc_redim`, x, di))
}

#' New Dimensions with Resizing
#'
#' Write new dimension vector while keeping the old memory if possible
#' New memory cannot be greater than the very first allocation
#' @param x_ A numeric array
#' @param di An integer vector, new dimensions
#' @return None
#' @examples
#' a=matrix(as.double(1:12), 6, 2)
#' resize(a, c(2, 2))
#' a
#' #      [,1] [,2]
#' # [1,]    1    3
#' # [2,]    2    4
#' @export
resize <- function(x_, di) {
    invisible(.Call(`_multbxxc_resize`, x_, di))
}

#' Transform Repeated Matrix Indexes
#'
#' Transforms a couple of index vectors ir and jc (ij of a sparse matrix)
#' with possibly repeated values into sparse indexes i,j and a vector of 1d indexes of non zero values.
#' The response can be then used for repeated creation of sparse
#' matrices with the same pattern by calling \code{iv2v()}
#' ir and jc are supposed to be sorted in increasing order, column-wise (ic runs first)
#' @param ir An integer vector, row indexes
#' @param jc An integer vector, column indexes
#' @return A list with fields i, j and iv
#' @export
ij2ijv_i <- function(ir, jc) {
    .Call(`_multbxxc_ij2ijv_i`, ir, jc)
}

#' Sum non Zero Repeated Values
#'
#' sum values in v according to possibly repeated indexes in iv
#' @param iv An integer vector, obtained with \code{ij2ijv_i(...)$iv}
#' @param v A numeric vector
#' @return Numeric vector
#' @export
iv2v <- function(iv, v) {
    .Call(`_multbxxc_iv2v`, iv, v)
}

#' Dot Product SparseMatrix*DenseArray
#'
#' Dot product of simple triplet matrix x (m x n) (measurement matrix) and a dense array y (n x k x l).
#' Only slices of y_ from lsel vector are used.
#' @param x A list, sparse matrix of type slam
#' @param y_ A numeric 3d array
#' @param lsel An integer vector
#' @return An array with dimensions (m x len(lsel) x k), i.e. it is permuted on the fly.
#' @export
mm_xpf <- function(x, y_, lsel) {
    .Call(`_multbxxc_mm_xpf`, x, y_, lsel)
}

#' Update Matrix by a Cascade of Dot Product
#'
#' \code{xpfw[...]-=jrhs%*%ff}
#' \code{dim(xpfw)=c(nb_row, nb_ff+nb_fgr, ntico)}
#' \code{dim(jrhs%*%ff)=c(nb_row*ntico, nb_ff+nb_fgr)}
#' @param jrhs A sparse matrix of type slam
#' @param ff A sparse matrix of type slam
#' @param xpfw A numeric matrix
#' @export
jrhs_ff <- function(jrhs, ff, xpfw) {
    invisible(.Call(`_multbxxc_jrhs_ff`, jrhs, ff, xpfw))
}

