% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiCA.R
\name{power.multiCA.test}
\alias{power.multiCA.test}
\title{Power calculations for the multinomial Cochran-Armitage trend test}
\usage{
power.multiCA.test(N = NULL, power = NULL, pmatrix = NULL, p.ave = NULL,
  p.start = NULL, p.end = NULL, slopes = NULL, scores = 1:G,
  n.prop = rep(1, G), G = length(p.ave), sig.level = 0.05)
}
\arguments{
\item{N}{integer, the total sample size of the study. If \code{NULL} then \code{power} needs to be specified.}

\item{power}{target power. If \code{NULL} then \code{N} needs to be specified.}

\item{pmatrix}{numeric matrix of hypothesized outcome probabilities in each group,  with #' the outcomes as rows and ordered groups as columns. The columns should add up to 1.}

\item{p.ave}{numeric vector of average probability of each outcome over the groups
weighted by \code{n.prop}.}

\item{p.start, p.end}{numeric vectors of the probability of each outcome for the
first / last ordered group}

\item{slopes}{numeric vector of the hypothesized slope of each outcome when regressed
against the column \code{scores} wiht weights \code{n.prop}}

\item{scores}{non-decreasing numeric vector of the same length as the number of ordered groups
giving the trend test scores. Defaults to linearly increasing values.}

\item{n.prop}{numeric vector describing relative sample sizes of the ordered groups.
Will be normalized to sum to 1. Defaults to equal sample sizes.}

\item{G}{integer, number of ordered groups}

\item{sig.level}{significance level}
}
\value{
object of class "power.htest"
}
\description{
Given the probabilities of outcomes, compute the power of the overall multinomial 
Cochran-Armitage trend test or determine the sample size to obtain a target power.
}
\details{
The distribution of the outcomes can be specified in two ways: either the full matrix of 
outcome probabilities \code{pmatrix} can be specified, or exactly two of the parameters 
\code{p.ave}, \code{slopes}, \code{p.start}, and \code{p.end} must be specified, while
}
\examples{
power.multiCA.test(power=0.8, p.start=c(0.1,0.2,0.3,0.4), p.end=c(0.4, 0.3, 0.2, 0.1), 
                     G=5, n.prop=c(3,2,1,2,3))

## Power of stroke study with 100 subjects per year and observed trends
data(stroke)
strk.mat <- xtabs(Freq ~ Type + Year, data=stroke)
power.multiCA.test(N=900, pmatrix=prop.table(strk.mat, margin=2))
}

