% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{statis}
\alias{statis}
\title{Structuration des Tableaux à Trois Indices de la Statistique - STATIS}
\usage{
statis(X, ncomp = 3, scannf = FALSE, tol = 1e-07, ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{ncomp}{\code{integer} number of components to extract.}

\item{scannf}{\code{logical} indicating if eigenvalue bar plot shoulde be displayed.}

\item{tol}{\code{numeric} eigenvalue threshold tolerance.}

\item{...}{additional arguments (not used).}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{ade4::statis} function for computing STATIS.
}
\details{
STATIS is a method, related to MFA, for analysing two or more blocks. It also
decomposes the data into a low-dimensional subspace but uses a different scaling of the
individual blocks.
}
\examples{
data(candies)
candyList <- lapply(1:nlevels(candies$candy),function(x)candies$assessment[candies$candy==x,])
can.statis <- statis(candyList)
plot(scores(can.statis), labels="names")

}
\references{
Lavit, C.; Escoufier, Y.; Sabatier, R.; Traissac, P. (1994). The ACT (STATIS method). Computational Statistics & Data Analysis. 18: 97
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
