% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.complr}
\alias{update.complr}
\title{Update \code{\link{complr}}}
\usage{
\method{update}{complr}(object, newdata, ...)
}
\arguments{
\item{object}{A \code{\link{complr}} class object to be updated.}

\item{newdata}{A \code{data.frame} or \code{data.table}
containing data of all variables used in the analysis.
It must include a composition and the same ID variable as the existing \code{\link{complr}} object.}

\item{...}{generic argument, not in use.}
}
\value{
A \code{\link{complr}} object with at least the following elements.
\item{\code{comp}}{ A vector of class \code{acomp} representing one closed composition
or a matrix of class \code{acomp} representing multiple closed  compositions each in one row.}
\item{\code{between_comp}}{ A vector of class \code{acomp} representing one closed between-person composition
or a matrix of class \code{acomp} representing multiple closed between-person compositions each in one row.}
\item{\code{within_comp}}{ A vector of class \code{acomp} representing one closed within-person composition
or a matrix of class \code{acomp} representing multiple closed within-person compositions each in one row.}
\item{\code{logratio}}{ Log ratio transform of composition.}
\item{\code{between_logratio}}{ Log ratio transform of between-person composition.}
\item{\code{within_logratio}}{ Log ratio transform of within-person composition.}
\item{\code{data}}{ The user's dataset or imputed dataset if the input data contains zeros.}
\item{\code{transform}}{ Type of transform applied on compositional data.}
\item{\code{parts}}{ Names of compositional variables.}
\item{\code{idvar}}{ Name of the variable containing IDs.}
\item{\code{total}}{ Total amount to which the compositions is closed.}
}
\description{
This method allows for updating an existing \code{\link{complr}} object.
}
\examples{
cilr <- complr(data = mcompd, sbp = sbp, 
               parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID")

# update with new data
newdat <- mcompd[ID != 1] # excluding ID 1
cilr1 <- update(object = cilr, newdata = newdat)
}
\seealso{
\code{\link{complr}}
}
