% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CJS.R
\name{getprobsCJS}
\alias{getprobsCJS}
\title{Calculate posterior capture and survival probabilities}
\usage{
getprobsCJS(out, link = "probit")
}
\arguments{
\item{out}{List of output returned by \code{\link{multimarkCJS}}}

\item{link}{Link function for \eqn{p} and \eqn{\phi}. Must be "\code{probit}" or "\code{logit}". Note that \code{\link{multimarkCJS}} is currently implemented for the probit link only.}
}
\value{
An object of class \code{\link[coda]{mcmc.list}} containing the following:
\item{p}{Posterior samples for capture probability (\eqn{p[c,t]}) for each release cohort (\eqn{c=1,\ldots,T-1}) and sampling occasion (\eqn{t=2,\ldots,T}).}
\item{phi}{Posterior samples for survival probability (\eqn{\phi[c,k]}) for each release cohort (\eqn{c=1,\ldots,T-1}) and interval (\eqn{k=1,\ldots,T-1}).}
}
\description{
This function calculates posterior capture (\eqn{p}) and survival (\eqn{\phi}) probabilities for each sampling occasion from \code{\link{multimarkCJS}} output.
}
\examples{
\dontshow{
test<-getprobsCJS(multimarkCJS(Enc.Mat=bobcat,data.type="never",iter=10,burnin=0))}
\donttest{
# This example is excluded from testing to reduce package check time
# Example uses unrealistically low values for nchain, iter, and burnin

#Simulate open population data with temporal variation in survival
noccas <- 5
data <- simdataCJS(noccas=noccas, phibeta=rnorm(noccas-1,1.6,0.1))
 
#Fit open population model with temporal variation in survival
sim.time <- multimarkCJS(data$Enc.Mat,mod.phi=~time)
    
#Calculate capture and survival probabilities for each cohort and time
pphi <- getprobsCJS(sim.time)
summary(pphi)}
}
\author{
Brett T. McClintock
}
\seealso{
\code{\link{multimarkCJS}}
}

