% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_color_multilevel.R
\name{set_color_multilevel}
\alias{set_color_multilevel}
\title{Set colors for levels of a multilevel network}
\usage{
set_color_multilevel(x, color.true = "blue", color.false = "red",
  V.alpha = 0.7, E.alpha = 0.7)
}
\arguments{
\item{x}{a graph object. Must be a multilevel network.}

\item{color.true}{a character. The color to be chosen for the higher
level (attribute \code{type} set to \code{TRUE}).}

\item{color.false}{a character. The color to be chosen for the lower
level (attribute \code{type} set to \code{FALSE}).}

\item{V.alpha}{numeric. The factor modifying the opacity alpha for the
vertices; typically in [0,1].}

\item{E.alpha}{numeric. The factor modifying the opacity alpha for the
edges; typically in [0,1].}
}
\value{
A graph object. A multilevel network with an added \code{color}
  vertex attribute vector and a \code{color} edge attribute vector.
}
\description{
Set vertices and edges colors for a multilevel network.
  Default set to blue (higher level) and red (lower level).
}
\examples{
# Check whether a graph is multilevel
is_multilevel(linked_sim)

# Set the colors for each level
linked_sim <- set_color_multilevel(linked_sim)


}
\author{
Neylson Crepalde, \email{neylsoncrepalde@gmail.com}
}
