% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_summary-class.R
\name{print.nma_summary}
\alias{print.nma_summary}
\alias{as.data.frame.nma_summary}
\alias{as.tibble.nma_summary}
\alias{as_tibble.nma_summary}
\alias{as.array.nma_summary}
\alias{as.matrix.nma_summary}
\alias{as.array.nma_rank_probs}
\alias{as.matrix.nma_rank_probs}
\title{Methods for \code{nma_summary} objects}
\usage{
\method{print}{nma_summary}(x, ..., digits = 2, pars, include = TRUE)

\method{as.data.frame}{nma_summary}(x, ...)

\method{as.tibble}{nma_summary}(x, ...)

\method{as_tibble}{nma_summary}(x, ...)

\method{as.array}{nma_summary}(x, ...)

\method{as.matrix}{nma_summary}(x, ...)

\method{as.array}{nma_rank_probs}(x, ...)

\method{as.matrix}{nma_rank_probs}(x, ...)
}
\arguments{
\item{x}{A \code{nma_summary} object}

\item{...}{Additional arguments passed on to other methods}

\item{digits}{Integer number of digits to display}

\item{pars}{Character vector of parameters to display in the printed summary}

\item{include}{Logical, are parameters named in \code{pars} included (\code{TRUE}) or excluded (\code{FALSE})}
}
\value{
A \code{data.frame} for \code{as.data.frame()}, a \code{tbl_df} for \code{as.tibble()}
and \code{as_tibble()}, a \code{matrix} for \code{as.matrix()}, and an \code{mcmc_array} for
\code{as.array()}.

The \code{print()} method returns \code{x} invisibly.
}
\description{
The \code{as.data.frame()}, \code{as_tibble()}, and \code{as.tibble()} methods return the
posterior summary statistics in a data frame or tibble. The \code{as.matrix()}
method returns a matrix of posterior draws. The \code{as.array()} method returns a
3D array [Iteration, Chain, Parameter] of posterior draws (as class
\link{mcmc_array}).
}
\seealso{
\code{\link[=plot.nma_summary]{plot.nma_summary()}}
}
