% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{plaque_psoriasis_ipd}
\alias{plaque_psoriasis_ipd}
\alias{plaque_psoriasis}
\alias{plaque_psoriasis_agd}
\title{Plaque psoriasis data}
\format{
The individual patient data are contained in a data frame
\code{plaque_psoriasis_ipd} with 4118 rows, one per individual, and 16 variables:
\describe{
\item{studyc}{study name}
\item{trtc_long}{treatment name (long format)}
\item{trtc}{treatment name}
\item{trtn}{numeric treatment code}
\item{pasi75}{binary PASI 75 outcome}
\item{pasi90}{binary PASI 90 outcome}
\item{pasi100}{binary PASI 100 outcome}
\item{age}{age (years)}
\item{bmi}{body mass index (BMI)}
\item{pasi_w0}{PASI score at week 0}
\item{male}{male sex (TRUE or FALSE)}
\item{bsa}{body surface area (percent)}
\item{weight}{weight (kilograms)}
\item{durnpso}{duration of psoriasis (years)}
\item{prevsys}{previous systemic treatment (TRUE or FALSE)}
\item{psa}{psoriatic arthritis (TRUE or FALSE)}
}

The aggregate data are contained in a data frame \code{plaque_psoriasis_agd} with 15
rows, one per study arm, and 26 variables:
\describe{
\item{studyc}{study name}
\item{trtc_long}{treatment name (long format)}
\item{trtc}{treatment name}
\item{trtn}{numeric treatment code}
\item{pasi75_r, pasi75_n}{PASI 75 outcome count and denominator}
\item{pasi90_r, pasi90_n}{PASI 75 outcome count and denominator}
\item{pasi100_r, pasi100_n}{PASI 75 outcome count and denominator}
\item{sample_size_w0}{sample size at week zero}
\item{age_mean, age_sd}{mean and standard deviation of age (years)}
\item{bmi_mean, bmi_sd}{mean and standard deviation of BMI}
\item{pasi_w0_mean, pasi_w0_sd}{mean and standard deviation of PASI score at week 0}
\item{male}{percentage of males}
\item{bsa_mean, bsa_sd}{mean and standard deviation of body surface area (percent)}
\item{weight_mean, weight_sd}{mean and standard deviation of weight (kilograms)}
\item{durnpso_mean, durnpso_sd}{mean and standard deviation of duration of psoriasis (years)}
\item{prevsys}{percentage of individuals with previous systemic treatment}
\item{psa}{percentage of individuals with psoriatic arthritis}
}

An object of class \code{data.frame} with 15 rows and 26 columns.
}
\usage{
plaque_psoriasis_ipd

plaque_psoriasis_agd
}
\description{
Two data frames, \code{plaque_psoriasis_ipd} and \code{plaque_psoriasis_agd},
containing (simulated) individual patient data from four studies and
aggregate data from five studies \insertCite{Phillippo_thesis}{multinma}.
Outcomes are binary success/failure to achieve 75\%, 90\%, or 100\% reduction in
symptoms on the Psoriasis Area and Severity Index (PASI) scale.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
