% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe-pipeline.R
\name{detect_multiverse_n}
\alias{detect_multiverse_n}
\title{Detect total number of analysis pipelines}
\usage{
detect_multiverse_n(.pipeline, include_models = TRUE)
}
\arguments{
\item{.pipeline}{a \code{data.frame} produced by calling a series of add_*
functions.}

\item{include_models}{Whether to count alternative models if you have more
than one \code{add_model()} call.}
}
\value{
a numeric, the total number of unique analysis pipelines
}
\description{
Detect total number of analysis pipelines
}
\examples{
library(tidyverse)
library(multitool)

# create some data
the_data <-
  data.frame(
    id  = 1:500,
    iv1 = rnorm(500),
    iv2 = rnorm(500),
    iv3 = rnorm(500),
    mod = rnorm(500),
    dv1 = rnorm(500),
    dv2 = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

# create a pipeline blueprint
full_pipeline <-
  the_data |>
  add_filters(include1 == 0, include2 != 3, include3 > -2.5) |>
  add_variables(var_group = "ivs", iv1, iv2, iv3) |>
  add_variables(var_group = "dvs", dv1, dv2) |>
  add_model("linear model", lm({dvs} ~ {ivs} * mod))

detect_multiverse_n(full_pipeline)
}
