% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview.path.R
\name{multiview.fit}
\alias{multiview.fit}
\title{Fit a GLM with elastic net regularization for a single value of
lambda}
\usage{
multiview.fit(
  x_list,
  x,
  y,
  rho,
  weights,
  lambda,
  alpha = 1,
  offset = rep(0, nobs),
  family = gaussian(),
  intercept = TRUE,
  thresh = 1e-07,
  maxit = 1e+05,
  penalty.factor = rep(1, nvars),
  exclude = c(),
  lower.limits = -Inf,
  upper.limits = Inf,
  warm = NULL,
  from.multiview.path = FALSE,
  save.fit = FALSE,
  trace.it = 0
)
}
\arguments{
\item{x_list}{a list of \code{x} matrices with same number of rows
\code{nobs}}

\item{x}{the column-binded entries of \code{x_list}}

\item{y}{the quantitative response with length equal to \code{nobs}, the
(same) number of rows in each \code{x} matrix}

\item{rho}{the weight on the agreement penalty, default 0. \code{rho=0} is a form
of early fusion, and \code{rho=1} is a form of late fusion.}

\item{weights}{observation weights. Can be total counts if
responses are proportion matrices. Default is 1 for each
observation}

\item{lambda}{A single value for the \code{lambda} hyperparameter.}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0 \le
  \alpha \le 1}.  The penalty is defined as
\deqn{(1-\alpha)/2||\beta||_2^2+\alpha||\beta||_1.}  \code{alpha = 1}
is the lasso penalty, and \code{alpha = 0} the ridge penalty.
\code{lambda.min.ratio}. Supplying a value of lambda overrides this.}

\item{offset}{A vector of length \code{nobs} that is included in the
linear predictor (a \code{nobs} by \code{nc} matrix for the \code{"multinomial"}
family).  Useful for the \code{"poisson"} family (e.g. log of exposure
time), or for refining a model by starting at a current
fit. Default is \code{NULL}. If supplied, then values must also be
supplied to the \code{predict} function.}

\item{family}{A description of the error distribution and link
function to be used in the model. This is the result of a call to
a family function. Default is \link[stats:family]{stats::gaussian}. (See
\link[stats:family]{stats::family} for details on family functions.)}

\item{intercept}{Should intercept be fitted (default \code{TRUE}) or set
to zero (\code{FALSE})?}

\item{thresh}{Convergence threshold for coordinate descent. Each
inner coordinate-descent loop continues until the maximum change
in the objective after any coefficient update is less than thresh
times the null deviance.  Default value is \code{1e-7}.}

\item{maxit}{Maximum number of passes over the data; default is
\code{10^5}.  (If a warm start object is provided, the number of
passes the warm start object performed is included.)}

\item{penalty.factor}{List of separate penalty factors can be
applied to each coefficient, consisting of \code{ncol(x)} elements for
each \code{x} in \code{x_list}. This is a number that multiplies \code{lambda}
to allow differential shrinkage. Can be 0 for some variables,
which implies no shrinkage, and that variable is always included
in the model. Default is 1 for all variables (and implicitly
infinity for variables listed in \code{exclude}). Note: the penalty
factors are internally rescaled to sum to \code{nvars}.}

\item{exclude}{List of column indices of \code{x} matrices in \code{x_list}
to be excluded from the model. Default is empty list. Equivalent
to an infinite penalty factor for the variables excluded (next
item).  Users can supply instead an \code{exclude()} function that
generates the list of \code{x} columns indices.  This function is most
generally defined as \verb{function(x_list, y, weights, ...)}, and is
called inside \code{\link[=multiview]{multiview()}} to generate the indices for excluded
variables.  The \code{...} argument is required, the others are
optional.  This is useful for filtering wide data, and works
correctly with \code{cv.multiview}.  See the vignette 'Introduction'
for examples.}

\item{lower.limits}{Vector of lower limits for each coefficient
consisting of \verb{ncol(x) elements for each }x\verb{in}x_list\verb{; default }-Inf`. Each of these must be non-positive.}

\item{upper.limits}{Vector of upper limits for each coefficient
consisting of \verb{ncol(x) elements for each }x\verb{in}x_list\verb{; default }Inf`. Each of these must be non-negative.}

\item{warm}{Either a \code{multiview} object or a list (with names
\code{beta} and \code{a0} containing coefficients and intercept
respectively) which can be used as a warm start. Default is
\code{NULL}, indicating no warm start.  For internal use only.}

\item{from.multiview.path}{Was \code{multiview.fit()} called from
\code{multiview.path()}?  Default is \code{FALSE}.This has implications for
computation of the penalty factors.}

\item{save.fit}{Return the warm start object? Default is \code{FALSE}.}

\item{trace.it}{Controls how much information is printed to
screen. If \code{trace.it = 2}, some information about the fitting
procedure is printed to the console as the model is being
fitted. Default is \code{trace.it = 0} (no information
printed). (\code{trace.it = 1} not used for compatibility with
\code{multiview.path}.)}
}
\value{
An object with class \code{"multiview"}. The list
returned contains more keys than that of a \code{"multiview"} object.
\item{a0}{Intercept value.}
\item{beta}{A \code{nvars} by \code{1} matrix of coefficients, stored in sparse matrix
format.}
\item{df}{The number of nonzero coefficients.}
\item{dim}{Dimension of coefficient matrix.}
\item{lambda}{Lambda value used.}
\item{lambda_scale}{The multiview lambda scale factor}
\item{dev.ratio}{The fraction of (null) deviance explained. The deviance
calculations incorporate weights if present in the model. The deviance is
defined to be 2*(loglike_sat - loglike), where loglike_sat is the log-likelihood
for the saturated model (a model with a free parameter per observation).
Hence dev.ratio=1-dev/nulldev.}
\item{nulldev}{Null deviance (per observation). This is defined to be
2*(loglike_sat -loglike(Null)). The null model refers to the intercept model.}
\item{npasses}{Total passes over the data.}
\item{jerr}{Error flag, for warnings and errors (largely for internal
debugging).}
\item{offset}{A logical variable indicating whether an offset was included
in the model.}
\item{call}{The call that produced this object.}
\item{nobs}{Number of observations.}
\item{warm_fit}{If \code{save.fit = TRUE}, output of C++ routine, used for
warm starts. For internal use only.}
\item{family}{Family used for the model.}
\item{converged}{A logical variable: was the algorithm judged to have
converged?}
\item{boundary}{A logical variable: is the fitted value on the boundary of
the attainable values?}
\item{obj_function}{Objective function value at the solution.}
}
\description{
Fit a generalized linear model via penalized maximum likelihood for
a single value of lambda. Can deal with any GLM family.
}
\details{
WARNING: Users should not call \code{multiview.fit}
directly. Higher-level functions in this package call
\code{multiview.fit} as a subroutine. If a warm start object is
provided, some of the other arguments in the function may be
overriden.

\code{multiview.fit} solves the elastic net problem for a \emph{single,
user-specified} value of lambda. \code{multiview.fit} works for any GLM
family. It solves the problem using iteratively reweighted least
squares (IRLS). For each IRLS iteration, \code{multiview.fit} makes a
quadratic (Newton) approximation of the log-likelihood, then calls
\code{elnet.fit} to minimize the resulting approximation.

In terms of standardization: \code{multiview.fit} does not standardize
\code{x} and \code{weights}. \code{penalty.factor} is standardized so that to sum
to \code{nvars}.
}
