% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colornum.R
\name{colornum}
\alias{colornum}
\title{Reference numbers for scale structures}
\usage{
colornum(set, ineqmat = NULL, signvector_list = NULL, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to "white," "roth", "pastel," or "rosy", giving the
\code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}}, \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}},
and \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}}. For other
arrangements, the desired inequality matrix can be entered directly.}

\item{signvector_list}{A list of signvectors to use as the reference by
which \code{colornum} assigns a value. Defaults to \code{NULL} and will attempt to
use \code{representative_signvectors}, which needs to be downloaded and assigned
separately from the package musicMCT.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Single non-negative integer (the color number) if a \code{signvector_list}
is specified or \code{representative_signvectors} is loaded; otherwise \code{NULL}
}
\description{
As described on p. 28 of "Modal Color Theory," it's convenient to have a
systematic labeling system ("color numbers") to refer to the distinct colors
in the hyperplane arrangements. This serves a similar function as Forte's
set class numbers do in traditional pitch-class set theory. Color numbers
are defined with reference to a complete list of the possible sign vectors
for each cardinality, so they depend on the extensive prior computation
that is stored in the object \code{representative_signvectors}. (This is a large
file that cannot be included in the package musicMCT itself. It needs to be
downloaded separately, saved in your working directory, and loaded by entering
\code{representative_signvectors <- readRDS("representative_signvectors.rds")}.
Color numbers are currently only defined for scales with 7 or fewer notes.
}
\details{
Note that the perfectly even "white" scale is number \code{0} for every cardinality
by definition.

The function assumes that you don't need to be reminded of
the cardinality of the set you've entered.
That is, there's a color number 2 for every cardinality, so you can get
that value returned by entering a trichord, tetrachord, etc.
}
\examples{
colornum(edoo(5))
colornum(c(0, 3, 7))
colornum(c(0, 2, 7))
colornum(c(0, 1, 3, 7))
colornum(c(0, 1, 3, 6, 10, 15, 21), edo=33)
colornum(c(0, 2, 4, 5, 7, 9, 11))
}
