% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signvector.R
\name{whichsvzeroes}
\alias{whichsvzeroes}
\alias{countsvzeroes}
\title{Which interval-comparison equalities does a scale satisfy?}
\usage{
whichsvzeroes(set, ineqmat = NULL, edo = 12, rounder = 10)

countsvzeroes(set, ineqmat = NULL, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to "white," "black", "gray", "roth", "pastel," or "rosy",
giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}}, \code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}},
\code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, and \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}}. For other
arrangements, the desired inequality matrix can be entered directly.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Single numeric value for \code{countsvzeroes} and a numeric vector
for \code{whichsvzeroes}
}
\description{
As "Modal Color Theory" (p. 26) describes, one useful measure of a scale's
\strong{regularity} is the number of zeroes in its sign vector. This indicates how
many hyperplanes a scale lies \emph{on}, a geometrical fact whose musical
interpretation is, roughly speaking, how many times two generic intervals equal each other
in specific size. (I say only "roughly speaking" because one hyperplane usually
represents multiple comparisons: see Appendix 1.1.) Scales with a great
degree of symmetry or other forms of regularity such as well-formedness
tend to be on a very high number of hyperplanes compared to all sets of
a given cardinality.

\code{musicMCT} offers two convenience functions that return pertinent information
from \code{\link[=signvector]{signvector()}}. \code{countsvzeroes} returns this \strong{count} of the number
of \strong{s}ign-\strong{v}ector \strong{zeroes}, while \code{whichsvzeroes} gives a list of
the specific hyperplanes the scale lines on (numbered according to their
position on the given \code{ineqmat}). The specific information in \code{whichsvzeroes}
can be useful because it determines the "flat" of the hyperplane arrangement
that the scale lies on, which is a more general kind of scalar structure
than color (as determined by the entire sign vector).
}
\examples{
# Sort 12edo heptachords by how many sign vector zeroes they have (from high to low)
heptas12 <- unique(apply(utils::combn(12, 7), 2, primeform), MARGIN=2)
heptas12_svzeroes <- apply(heptas12, 2, countsvzeroes)
colnames(heptas12) <- apply(heptas12, 2, fortenum)
heptas12[, order(heptas12_svzeroes, decreasing=TRUE)]

# Multiple hexachords on the same flat but of different colors
hex1 <- c(0, 2, 4, 5, 7, 9)
hex2 <- convert(c(0, 1, 2, 4, 5, 6), 9, 12)
hex3 <- convert(c(0, 3, 6, 8, 11, 14), 15, 12)
hex_words <- rbind(asword(hex1), asword(hex2), asword(hex3))
rownames(hex_words) <- c("hex1", "hex2", "hex3")
c(colornum(hex1), colornum(hex2), colornum(hex3))
whichsvzeroes(hex1)
whichsvzeroes(hex2)
whichsvzeroes(hex3)
hex_words

}
