% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{removeWeak}
\alias{removeWeak}
\title{Remove Mutation Types Not Meeting the Threshold.}
\usage{
removeWeak(input_mutCounts, params)
}
\arguments{
\item{input_mutCounts}{numeric matrix of Mutation Counts}

\item{params}{object (list) including all parameters required for running the analysis}
}
\value{
List including two elements:
\enumerate{
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\description{
Remove mutation types that account for a total number of mutations below a defined threshold.
}
\details{
This is one of the core functions included in the original mutSignatures R library, 
and in the WTSI MATLAB framework. This is an internal function.
}
\examples{
x <- mutSignatures:::getTestRunArgs("removeWeak")
nrow(x$data)
y <- mutSignatures:::removeWeak(input_mutCounts = x$data, params = x$params)
nrow(y)
  
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
