/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.io.datasets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLSToolkit {
    public static void convertXls2Csv(File xls, int sheetNr, File outFile, String sep) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)new FileInputStream(xls));
        HSSFSheet sheet = wb.getSheetAt(sheetNr);
        Iterator rowIt = sheet.rowIterator();
        int nonEmpty = Integer.MIN_VALUE;
        while (rowIt.hasNext()) {
            HSSFRow row = (HSSFRow)rowIt.next();
            Iterator cellIt = row.cellIterator();
            int len = 0;
            int empt = 0;
            while (cellIt.hasNext()) {
                String x = cellIt.next().toString();
                ++len;
                if (x.trim().equals("")) {
                    ++empt;
                    continue;
                }
                empt = 0;
            }
            nonEmpty = Math.max(nonEmpty, len - empt);
        }
        rowIt = sheet.rowIterator();
        BufferedWriter w = new BufferedWriter(new FileWriter(outFile));
        while (rowIt.hasNext()) {
            int count;
            HSSFRow row = (HSSFRow)rowIt.next();
            Iterator cellIt = row.cellIterator();
            for (count = 0; cellIt.hasNext() && count < nonEmpty; ++count) {
                w.write(cellIt.next().toString());
                if (!cellIt.hasNext()) continue;
                w.write(sep);
            }
            if (count < nonEmpty) {
                for (int i = 0; i < nonEmpty - count; ++i) {
                    w.write(sep);
                }
            }
            w.newLine();
        }
        w.close();
    }

    public static List<String> getXLSTables(File file) throws FileNotFoundException, IOException {
        ArrayList<String> result = new ArrayList<String>();
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)new FileInputStream(file));
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            result.add(wb.getSheetName(i));
        }
        return result;
    }

    public static List<String> getXLSXTables(File file) throws FileNotFoundException, IOException {
        return null;
    }

    public static void convertXlsX2Csv(File xlsx, int sheetNr, File outFile, String sep) throws IOException {
    }
}

