% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutual.R
\name{mutual}
\alias{mutual}
\title{Computes and decomposes the Mutual Information index}
\usage{
mutual(
  data,
  group,
  unit,
  within = NULL,
  by = NULL,
  contribution.from = NULL,
  components = FALSE,
  cores = NULL
)
}
\arguments{
\item{data}{An object from the "data.table" and "mutual.data" classes.}

\item{group}{A categorical variable name or vector of categorical variables names contained in \code{data}, or also,
a column number or vector of column numbers of \code{data}. Defines the first dimension over which segregation is
computed.}

\item{unit}{A categorical variable name or vector of categorical variables names contained in \code{data}, or also,
a column number or vector of column numbers of \code{data}. Defines the second dimension over which segregation is
computed.}

\item{within}{A categorical variable name or vector of categorical variables names contained in \code{data}, or also,
a column number or vector of column numbers of \code{data}. Defines the partitions to compute the between and within
decompositions. By default is \code{NULL}.}

\item{by}{A categorical variable name or vector of categorical variables names contained in \code{data}, or also,
a column number or vector of column numbers of \code{data}. Defines the subsamples over which indexes are computed.
By default is \code{NULL}.}

\item{contribution.from}{A variable of character type that can be 'group_vars' or 'unit_vars', or also, a categorical
variable name or vector of categorical variables names contained in the \code{group} parameter or \code{unit}
parameter, or also, a column number or vector of column numbers in the \code{group} parameter or the \code{unit}
parameter. Defines the segregation sources whose exclusive contributions to the "within" terms and the overall index
are computed. By default is \code{NULL}.}

\item{components}{A boolean value. If TRUE and the \code{within} option is not \code{NULL} and the \code{by} option is \code{NULL},
then it returns a list where the first element is a \code{data.table} that contains a summary of the index total value and
its decompositions, while the second element is a \code{data.table} with more detailed information of the decomposition of the
"within" term (the mathematical components required to compute the within terms). If the \code{within} and \code{by}
options are not \code{NULL}, then the function returns a list of lists where each first element is a \code{data.table} that contains
the summary of the index total value and decompositions in a given subsample, while each second element is a \code{data.table}
with more detailed information of the decomposition of the within term displayed in each first element in the same
subsample. By default is FALSE.}

\item{cores}{A positive integer. Defines the amount of CPU cores to use in parallelization tasks. If \code{NULL}, then the
computation is carried out in only one core. This option is available to Mac, Linux, Unix, and BSD systems
but is not available to Windows sytems. By default is \code{NULL}.}
}
\value{
A \code{data.table} if the \code{components} option is \code{FALSE}; a list if the \code{components} option is \code{TRUE},
the \code{within} option is not \code{NULL} and the \code{by} option is \code{NULL}; or a list of lists if the \code{components}
option is \code{TRUE}, and both \code{within} and \code{by} options are not \code{NULL}.
}
\description{
Computes and decomposes the Mutual Information index into "between" and "within" terms. The
"within" terms can also be decomposed into "exclusive contributions" of segregation sources defined either by group
or unit characteristics. The mathematical components required to compute each "within" term can also be displayed at
the user's request. The results can be computed over subsamples defined by the user.
}
\details{
Mixing \code{group} variables with \code{unit} variables in \code{contribution.from} will produce an error.
}
\examples{
\donttest{
# To compute the overall measure of school segregation by socioeconomic and ethnic status.
mutual(data = DT_test, group = c("csep", "ethnicity"), unit = "school")

# Computation of the exclusive effect of specific segregation sources on the overall measure, e.g.,
# socioeconomic and ethnic contributions, and the contribution that cannot be attributed to any of
# them (the "interaction" term).
mutual(data = DT_test, group = c("csep", "ethnicity"), unit = "school", by = "region",
contribution.from = "group_vars")

# For more information on the package, refer to the manual and the README file.
}
}
\references{
Frankel, D. and Volij, O. (2011). Measuring school segregation. \emph{Journal of Economic Theory, 146}(1):1-38.
\doi{10.1016/j.jet.2010.10.008}.

Guinea-Martin, D., Mora, R., & Ruiz-Castillo, J. (2018). The evolution of gender segregation over the life course.
\emph{American Sociological Review, 83}(5), 983-1019. \doi{10.1177/0003122418794503}.

Mora, R. and Guinea-Martin, D. (2021). Computing decomposable multigroup indexes of segregation. \emph{UC3M Working
papers, Economics 31803}. Universidad Carlos III de Madrid. Departamento de Economía.

Mora, R. and Ruiz-Castillo, J. (2011). Entropy-based segregation indices. \emph{Sociological Methodology, 41}(1):159-194.
\doi{10.1111/j.1467-9531.2011.01237.x}.

Theil, H. and Finizza, A. J. (1971). A note on the measurement of racial integration of schools by means of
informational concepts. \emph{The Journal of Mathematical Sociology, 1}(2):187-193. \doi{10.1080/0022250X.1971.9989795}.
}
