% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvtb_summary.R
\name{mvtb.cluster}
\alias{mvtb.cluster}
\title{Clustering the covariance explained or relative influence matrix}
\usage{
mvtb.cluster(x, clust.method = "complete", dist.method = "euclidean",
  plot = FALSE, ...)
}
\arguments{
\item{x}{Any table, such as \code{mvtb.covex(object)}, or \code{mvtb.ri(object)}. If \code{x} is an \code{mvtb} object, defaults to \code{mvtb.covex(x)}}

\item{clust.method}{clustering method for rows and columns. This should be (an unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"}, \code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (= WPGMC) or \code{"centroid"} (= UPGMC).}

\item{dist.method}{method for computing the distance between two lower triangular covariance matrices. This must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} or \code{"minkowski"}. Any unambiguous substring can be given.}

\item{plot}{Produces a heatmap of the covariance explained matrix. see \code{?mvtb.heat}}

\item{...}{Arguments passed to \code{mvtb.heat}}
}
\value{
clustered covariance matrix, with re-ordered rows and columns.
}
\description{
The 'covariance explained' by each predictor is the reduction in covariance between each pair of outcomes due to splitting on each predictor over all trees (\code{$covex}).
To aid in the interpretability of the covariance explained matrix, this function clusters the rows (pairs of outcomes) and the columns (predictors) of \code{object$covex}
so that groups of predictors that explain similar pairs of covariances are closer together.
This function can also be used to cluster the relative influence matrix. In this case, the rows (usually outcomes) and columns (usually predictors) with similar values will
be clustered together.
}
\details{
The covariance explained by each predictor is only unambiguous if the predictors are uncorrelated and interaction.depth = 1. 
If predictors are not independent, the decomposition of covariance explained is only approximate (like the decomposition of R^2 by each predictor in a linear model). 
If interaction.depth > 1, the following heuristic is used: the covariance explained by the tree is assigned to the predictor with the largest influence in each tree.

Note that different distances measures (e.g. \code{"manhattan"}, \code{"euclidean"}) provide different ways to measure (dis)similarities between 
the covariance explained patterns for each predictor. See \code{?dist} for further details.
After the distances have been computed, \code{hclust} is used to form clusters. 
Different clustering methods (e.g. \code{"ward.D"}, \code{"complete"}) generally group rows and columns differently (see \code{?hclust} for further details).
It is suggested to try different distance measures and clustering methods to obtain the most interpretable solution. 
The defaults are for \code{"euclidean"} distances and \code{"complete"} clustering.
Transposing the rows and columns may also lead to different results.

A simple heatmap of the clustered matrix can be obtained by setting \code{plot=TRUE}. Details of the plotting procedure are available via \code{mvtb.heat}.

\code{covex} values smaller than \code{getOption("digits")} are truncated to 0. Note that it is possible to obtain negative variance explained
due to sampling fluctuation. These can be truncated or ignored.
}
\seealso{
\code{mvtb.heat}
}

