# mwTensor
R package for Multi-way Component Analysis

Installation
======
~~~~
git clone https://github.com/rikenbit/mwTensor/
R CMD INSTALL mwTensor
~~~~

or type the code below in the R console window

~~~~
library(devtools)
devtools::install_github("rikenbit/mwTensor")
~~~~

References
======
- **Multi-way Component Analysis**
  - Andrzej Cichocki et al., Tensor Networks for Dimensionality Reduction and Large-scale Optimization: Part 1 Low-Rank Tensor Decompositions, 2016
  - Andrzej Cichocki et al., Tensor Decompositions for Signal Processing Applications, IEEE SIGNAL PROCESSING MAGAZINE, 2015
- **Singular Value Decomposition**: Gene H. Golub et al., Matrix Computation (Johns Hopkins Studies in the Mathematical Sciences), Johns Hopkins University Press, 2012
- **Alternating Least Square Singular Value Decomposition (ALS-SVD)**: Madeleine Udell et al., Generalized Low Rank Models, Foundations and Trends in Machine Learning, 9(1), 2016
- **Non-negative Matrix Factorization (NMF)** : CICHOCK, et. al., Nonnegative Matrix and Tensor Factorizations, Andrzej 2009
- **Independent Component Analysis (ICA)**: A. Hyvarinen. Fast and Robust Fixed-Point Algorithms for Independent Component Analysis. IEEE Transactions on Neural Networks, 10(3), 626-634, 1999
- **CX Decomposition**: Petros Drineas et al., Relative-Error CUR Matrix Decompositions, SIAM Journal on Matrix Analysis and Applications, 30(2), 844-881, 2008

## License
Copyright (c) 2021 Koki Tsuyuzaki and Laboratory for Bioinformatics Research, RIKEN Center for Biosystems Dynamics Reseach
Released under the [Artistic License 2.0](https://www.perlfoundation.org/artistic-license-20.html).

## Authors
- Koki Tsuyuzaki
