% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxsem_group_by.R
\name{mxsem_group_by}
\alias{mxsem_group_by}
\title{mxsem_group_by}
\usage{
mxsem_group_by(
  mxModel,
  grouping_variables,
  parameters = c(".*"),
  use_grepl = TRUE
)
}
\arguments{
\item{mxModel}{mxModel with the entire data}

\item{grouping_variables}{Variables used to split the data in groups}

\item{parameters}{the parameters that should be group specific. By default
all parameters are group specific.}

\item{use_grepl}{if set to TRUE, grepl is used to check which parameters are
group specific. For instance, if parameters = "a" and use_grepl = TRUE, all parameters
whose label contains the letter "a" will be group specific. If use_grep = FALSE
only the parameter that has the label "a" is group specific.}
}
\value{
mxModel with multiple groups. Use get_groups to extract the groups
}
\description{
creates a multi-group model from an OpenMx model.
}
\details{
mxsem_group_by creates a multi-group model by splitting the data found
in an mxModel object using dplyr's group_by function. The general idea is
as follows:

1. The function extracts the data from mxModel
2. The data is split using the group_by function of dplyr with the variables
in grouping_variables
3. a separate model is set up for each group. All parameters that match
those specified in the parameters argument are group specific

**Warning**: The multi-group model may differ from **lavaan**! For instance,
**lavaan** will automatically set the latent variances for all but the first
group free if the loadings are fixed to equality. Such automatic procedures
are not yet implemented in **mxsem**.
}
\examples{
# THE FOLLOWING EXAMPLE IS ADAPTED FROM
# https://openmx.ssri.psu.edu/docs/OpenMx/latest/_static/Rdoc/mxModel.html
library(mxsem)

model <- 'spatial =~ visual + cubes + paper
          verbal  =~ general + paragrap + sentence
          math    =~ numeric + series + arithmet'

mg_model <- mxsem(model = model,
                  data  = OpenMx::HS.ability.data) |>
  # we want separate models for all combinations of grades and schools:
  mxsem_group_by(grouping_variables = "school") |>
  mxTryHard()

# let's summarize the results:
summarize_multi_group_model(mg_model)
}
