% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{mc_filter}
\alias{mc_filter}
\title{Filter data from myClim object}
\usage{
mc_filter(
  data,
  localities = NULL,
  sensors = NULL,
  reverse = FALSE,
  stop_if_empty = TRUE
)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}

\item{localities}{locality_ids for filtering data; if NULL then do nothing}

\item{sensors}{sensor_names for filtering data; if NULL then do nothing see \code{names(mc_data_sensors)}}

\item{reverse}{if TRUE then input localities and/or sensors are excluded (default FALSE)}

\item{stop_if_empty}{if TRUE then error for empty output (default TRUE)}
}
\value{
filtered myClim object
}
\description{
This function filter data by localities and sensors.
}
\details{
In default settings it returns the object containing input sensors / localities.
When you provide vector of localities e.g. \code{localities=c("A6W79", "A2E32")}
selected localities are filtered with all sensors on those localities.
The same as When you provide vector of sensors \code{sensors=c("TMS_T1", "TMS_T2")},
selected sensors are filtered through all localities.
When you combine localities and sensors, then filtering return
selected sensors on selected localities.

When \code{reverse = TRUE} and using only localities parameter then
the listed localities are removed. Similarly \code{reverse = TRUE} with proving only
sensors parameter, then the listed sensors are removed from all localities. When
using \code{reverse = TRUE} and combining sensors and localities parameters then
selected sensors are removed from selected localities.
}
\examples{
## keep only "A6W79", "A2E32" localities with all their sensors
filtered_data <- mc_filter(mc_data_example_raw, localities=c("A6W79", "A2E32"))

## remove "A6W79", "A2E32" localities and keep all others
filtered_data <- mc_filter(mc_data_example_raw, localities=c("A6W79", "A2E32"), reverse=TRUE)

## keep only "TMS_T1", and "TMS_T2" sensors on all localities
filtered_data <- mc_filter(mc_data_example_raw, sensors=c("TMS_T1", "TMS_T2"))

## remove "TMS_T1", and "TMS_T2" sensors from all localities
filtered_data <- mc_filter(mc_data_example_raw, sensors=c("TMS_T1", "TMS_T2"),reverse=TRUE)

## keep only "TMS_T1", and "TMS_T2" sensors on "A6W79", "A2E32" localities
filtered_data <- mc_filter(mc_data_example_raw, localities=c("A6W79", "A2E32"),
                           sensors=c("TMS_T1", "TMS_T2"))

## remove "TMS_T1", and "TMS_T2" sensors from "A6W79", "A2E32" localities
## and keep all other sensors and localities
filtered_data <- mc_filter(mc_data_example_raw, localities=c("A6W79", "A2E32"),
                           sensors=c("TMS_T1", "TMS_T2"), reverse=TRUE)
}
