% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzipmed_package.R
\name{lmoutzimed}
\alias{lmoutzimed}
\title{Mediation Analysis for Zero-Inflated Count Mediators using MZIP (Continuous Outcome)}
\usage{
lmoutzimed(
  outcome,
  mediator,
  exposure,
  confounder = NULL,
  C = NULL,
  n = 1000,
  X = 1,
  Xstar = 0,
  error = "Delta",
  robust = FALSE
)
}
\arguments{
\item{outcome}{is the continuous outcome variable}

\item{mediator}{is the zero-inflated mediator variable, currently only 1 mediator allowed}

\item{exposure}{is the primary exposure being considered, only 1 is allowed}

\item{confounder}{is a vector of confounder variables. If no confounder variables are needed then confounder is set to NULL. If more than 1 confounder is being considered then use the cbind function, e.g. cbind(var1,var2)}

\item{C}{is a vector for theoretical values of each confounder. By default each each value of C will be the mean value of each confounder.}

\item{n}{is the number of repetition if bootstrapped errors are used}

\item{X}{is the theoretical value for the exposure variable to be set at. The default is to 1}

\item{Xstar}{is the theoretical value for the exposure variable to be compared to X. The default is 0, so direct, indirect, and proportion mediated values will be for a 1 unit increase in the exposure variable.}

\item{error}{='Delta' for delta method standard errors and ='Boot' for bootstrap. Default is delta method}

\item{robust}{indicates if a robust covariance matrix should be used for MZIP in delta method derivations. Default is FALSE.}
}
\value{
The function will return a list of 12 elements.
LM is the results of regressing the mediator+exposure+confounder on the outcome using a linear model \cr
MZIP is the results of regressing the exposure and confounders on the mediator using the MZIP model \cr
NDE is the direct effect \cr
NIE is the indirect effect. \cr
NDEse is the standard error for the  direct effect \cr
NDEci is the 95\% confidence interval for the direct effect\cr
NIEse is the standard error for  the indirect effect \cr
NIEci is the 95\% confidence interval for the indirect effect \cr
TE is the total effect \cr
TEse is the standard error for the total effect \cr
TECI is the confidence interval for the total effect \cr
PM is the proportion mediated
}
\description{
This function incorporates the MZIP model into the counterfactual approach to mediation analysis
as proposed by Vanderweele when the mediator is a Zero-Inflated count variable. Errors for
direct and indirect effects are computed using delta method or bootstrap. Note: This function
assumes that the outcome is continuous and all exposure, mediator, outcome, and covariates
have the same sample size. Binary variables must be dummy coded prior.
}
\examples{
    #Example with delta method
    zimed=lmoutzimed(outcome=mzipmed_data$lmY,mediator=mzipmed_data$ziM,
                 exposure=mzipmed_data$X,confounder=cbind(mzipmed_data$C1,
                 mzipmed_data$C2),error="Delta",robust=FALSE,X=1,Xstar=0)

    #Example using bootstrapping, 10 iterations used for succinctness
    zimed2=lmoutzimed(outcome=mzipmed_data$lmY,mediator=mzipmed_data$ziM,
                  exposure=mzipmed_data$X,confounder=cbind(mzipmed_data$C1,
                   mzipmed_data$C2),error="Boot",n=10,C=c(0,0.5))
}
