% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-fix_region.R
\name{fix_region}
\alias{fix_region}
\alias{fix_region.states}
\alias{fix_region.lgas}
\alias{fix_region.default}
\title{Fix Region Names}
\usage{
fix_region(x, ...)

\method{fix_region}{states}(x, ...)

\method{fix_region}{lgas}(x, interactive = FALSE, quietly = FALSE, ...)

\method{fix_region}{default}(x, ...)
}
\arguments{
\item{x}{An S3 object of class \code{states} or \code{lgas}. For 
\code{fix_region.default}, a character vector can be passed but only
that for States will be interpretable.}

\item{...}{Arguments passed to methods.}

\item{interactive}{Logical. When \code{TRUE}, the function prompts the user
to interactively select the correct LGA names from a list of available
options.}

\item{quietly}{Logical; default argument is \code{FALSE}.}
}
\value{
The transformed object. If all names are correct, the object is
returned unchanged.
}
\description{
Correct any misspelt names of administrative regions i.e. States and LGAs
}
\details{
The function will look through a character vector and try to 
determine if State or LGA names have been wrongly entered. This presupposes that
the atomic vector is of type \code{character}. It does not test any missing
values in the vector, leaving them untouched.
}
\note{
When passed a character vector of length \code{1L}, in the case of a
misspelt LGA, the function signals an error; the presumption is that a fix
can readily be applied interactively. When all the items provided are 
misspelt, nothing happens, but the user is advised to use the appropriate
constructor function so as to improve the accuracy of the repairs. When
there is a mix of misspelt and properly spelt LGAs, other functionalities
for fixing the mistakes are available via mode \code{interactive}.
}
\examples{
try(fix_region("Owerri north")) # ERROR
fix_region(c("Owerri north", "Owerri West"))

}
