% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-regions.R
\name{states}
\alias{states}
\alias{print.regions}
\alias{head.regions}
\alias{tail.regions}
\title{Create an Object for the States of Nigeria}
\usage{
states(states, gpz = NULL, all = TRUE, warn = TRUE)

\method{print}{regions}(x, ...)

\method{head}{regions}(x, ...)

\method{tail}{regions}(x, ...)
}
\arguments{
\item{states}{A character vector with strings representing one or more 
States of Nigeria. If missing, the function will return a \code{states} 
all the States, with or without the Federal Capital Territory (FCT).}

\item{gpz}{\code{NULL} (the default) or, case insensitively, one or more of
the following strings: \code{"nc", "ne", "nw", "se", "ss"} and \code{"sw"} 
(see "Details").}

\item{all}{logical; whether to include the FCT in the result.}

\item{warn}{logical; issue a warning when one or more elements are not
actually States (i.e. they were misspelt).}

\item{x}{The object of class \code{region}}

\item{...}{Arguments to \code{tail.default}}
}
\value{
The States of Nigeria as a whole or by zones, as an S3 object 
of class \code{states}.
}
\description{
Create an Object for the States of Nigeria

Print regions

Return the First or Last Parts of a Region Object
}
\details{
\code{gpz} represents a geopolitical zone which, in the Nigerian 
context, is a national subdivision that groups contiguous states that bear
certain socio-cultural and political similarities. Historically, they arise
from sub-national administrative divisions known as 'Regions' that existed 
at the time of the country's independence. There are at present 6 such 
zones - North-Central, North-East, North-West, South-East,South-South and 
South-West.
}
\examples{
states()  # lists names of all States
states(gpz = "se")  # lists States in South-East zone

}
