% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{group_by_fun}
\alias{group_by_fun}
\title{Group By Helper}
\usage{
group_by_fun(data, .fun)
}
\arguments{
\item{data}{data.frame, which will be grouped}

\item{.fun}{a function to apply}
}
\value{
a dataframe with the function applied to each group
}
\description{
This is a wrapper to facilitate the \code{grouped_df} S3 method.
}
\examples{

\dontrun{
miss_case_table.grouped_df <- function(data){
group_by_fun(data,.fun = miss_case_table)
}
airquality \%>\%
group_by(Month) \%>\%
miss_case_table()
}

}
