% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncurl.R
\name{ncurl_session}
\alias{ncurl_session}
\title{ncurl Session}
\usage{
ncurl_session(
  url,
  convert = TRUE,
  method = NULL,
  headers = NULL,
  data = NULL,
  response = NULL,
  pem = NULL
)
}
\arguments{
\item{url}{the URL address.}

\item{convert}{[default TRUE] logical value whether to attempt conversion of
the received raw bytes to a character vector. Supplying a non-logical
value will error.}

\item{method}{(optional) the HTTP method (defaults to 'GET' if not specified).}

\item{headers}{(optional) a named list or character vector specifying the
HTTP request headers e.g. \code{list(`Content-Type` = "text/plain")} or
\code{c(Authorization = "Bearer APIKEY")}. Supplying a non-named list or
vector will error.}

\item{data}{(optional) the request data to be submitted.}

\item{response}{(optional) a character vector or list specifying the response
headers to return e.g. \code{c("date", "server")} or \code{list("Date", "Server")}.
These are case-insensitive and will return NULL if not present.}

\item{pem}{(optional) applicable to secure HTTPS sites only. The path to a
file containing X.509 certificate(s) in PEM format, comprising the
certificate authority certificate chain (and revocation list if present).
If missing or NULL, certificates are not validated.}
}
\value{
An 'ncurlSession' object.
}
\description{
nano cURL - a minimalist http(s) client. A session encapsulates a connection,
    along with all related parameters. A session may be used multiple times
    to return data by repeatedly calling \code{\link{transact}}.
}
\examples{
s <- tryCatch(ncurl_session("https://httpbin.org/get", response = c("date")), error = identity)
s

}
