% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuron.R
\name{smooth_neuron}
\alias{smooth_neuron}
\alias{smooth_segment_gauss}
\title{Smooth the 3D coordinates of a neuron skeleton}
\usage{
smooth_neuron(n, method = c("gauss", "spline"), ...)

smooth_segment_gauss(xyz, sigma, ...)
}
\arguments{
\item{n}{Neuron to smooth}

\item{method}{Smoothing method}

\item{...}{Additional parameters passed to segment smoothing functions}

\item{xyz}{A block of 3D coordinates defining an unbranched segment}

\item{sigma}{The standard deviation of the Gaussian smoothing kernel (which
has the same spatial units as the object being smoothed)}
}
\value{
A new neuron with smoothed 3d coordinates
}
\description{
\code{smooth_neuron} smooths a neuron.
}
\examples{
ns=smooth_neuron(Cell07PNs[[1]], sigma=2)
# plot in 2D zooming in on axon terminals 
plot(Cell07PNs[[1]], col='grey', xlim=c(260,290), ylim=c(115,90))
plot(ns, col='red', add=TRUE)
\donttest{
# 3D plot
plot3d(Cell07PNs[[1]], col='grey')
plot3d(ns, col='red')
}
}
