% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngraph.R
\name{strahler_order}
\alias{strahler_order}
\title{Find the Strahler order of each point in a neuron}
\usage{
strahler_order(x)
}
\arguments{
\item{x}{A neuron}
}
\value{
A list containing \itemize{
  
  \item points Vector of integer Strahler orders for each point in the neuron
  
  \item segments Vector of integer Strahler orders for each segment in the 
  neuron }
}
\description{
The Strahler order will be 1 for each tip segment and then 1 + 
  the maximum of the Strahler order of each parent segment for internal 
  segments. Branch points will have the Strahler order of the closest segment
  to the root of which they are part.
}
\details{
It is vital that the root of the neuron is valid since this 
  determines the flow direction for calculation of the Strahler order. At 
  present the function is not defined for neurons with multiple subtrees.
  
  Internally, this function uses \code{\link{segmentgraph}} to find a reduced
  segmentgraph for the neuron.
}
\references{
\url{https://en.wikipedia.org/wiki/Strahler_number}
}
\seealso{
\code{\link{prune_strahler}}, a \code{\link{segmentgraph}} (a form
  of \code{\link{ngraph}}) representation is used to calculate the Strahler 
  order.
}

