% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogAUC.R
\name{LogAUC}
\alias{LogAUC}
\title{Area Under the Curve(AUC) and Area Under the first Moment Curve(AUMC) by
linear-up log-down method}
\usage{
LogAUC(x, y)
}
\arguments{
\item{x}{vector values of independent variable, usually time}

\item{y}{vector values of dependent variable, usually concentration}
}
\value{
\item{AUC}{area under the curve} \item{AUMC}{area under the first
moment curve}
}
\description{
It calculates AUC and AUMC using linear-up log-down method
}
\details{
This function returns AUC and AUMC by linear-up log-down method.
}
\examples{
LogAUC(Theoph[Theoph$Subject==1, "Time"],Theoph[Theoph$Subject==1, "conc"])
# Compare the last line with the above
AUC(Theoph[Theoph$Subject==1, "Time"],Theoph[Theoph$Subject==1, "conc"], Method="Log")
}
\references{
\enumerate{ \item Gabrielsson J, Weiner D. Pharmacokinetic and
Pharmacodynamic Data Analysis - Concepts and Applications. 5th ed. 2016.
\item Shargel L, Yu A. Applied Biopharmaceutics and Pharmacokinetics. 7th
ed. 2015.  \item Rowland M, Tozer TN. Clinical Pharmacokinetics and
Pharmacodynamics - Concepts and Applications. 4th ed. 2011. \item Gibaldi M,
Perrier D. Pharmacokinetics. 2nd ed. revised and expanded. 1982. }
}
\seealso{
\code{\link{LinAUC}},\code{\link{AUC}}
}
\keyword{AUC}

