% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{nc.get.compress.dims}
\alias{nc.get.compress.dims}
\title{Get X and Y dimension variables for reduced (compressed) grids}
\usage{
nc.get.compress.dims(f, v)
}
\arguments{
\item{f}{The file (an object of class \code{ncdf4})}

\item{v}{The name of a variable}
}
\value{
A list consisting of two members of class \code{ncdim4}: x.dim for the X axis, and y.dim for the Y axis.
}
\description{
Get X and Y dimension variables for reduced (compressed) grids.
}
\details{
The CF metadata convention defines a method for implementing reduced grids (grids missing pieces of themselves); they call this compression by gathering. This function retrieves the X and Y dimensions for reduced (compressed) grids, returning a list containing the X and Y dimensions.
}
\examples{
## Get compress dimensions from file.
\dontrun{
f <- nc_open("pr.nc")
compress.dims <- nc.get.compress.dims(f, "pr")
nc_close(f)
}

}
\references{
\url{http://cfconventions.org/Data/cf-conventions/cf-conventions-1.8/cf-conventions.html#reduced-horizontal-grid}
}
