% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFAxisDiscrete.R
\docType{class}
\name{CFAxisDiscrete}
\alias{CFAxisDiscrete}
\title{CF discrete axis object}
\description{
This class represent discrete CF axes, i.e. those axes whose
coordinate values do not represent a physical property. The coordinate
values are ordinal values equal to the index into the axis.
}
\section{Super classes}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{\link[ncdfCF:CFAxis]{ncdfCF::CFAxis}} -> \code{CFAxisDiscrete}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{dimnames}}{(read-only) The coordinates of the axis as an integer
vector, or labels for every axis element if they have been set.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFAxisDiscrete-new}{\code{CFAxisDiscrete$new()}}
\item \href{#method-CFAxisDiscrete-print}{\code{CFAxisDiscrete$print()}}
\item \href{#method-CFAxisDiscrete-brief}{\code{CFAxisDiscrete$brief()}}
\item \href{#method-CFAxisDiscrete-indexOf}{\code{CFAxisDiscrete$indexOf()}}
\item \href{#method-CFAxisDiscrete-subset}{\code{CFAxisDiscrete$subset()}}
\item \href{#method-CFAxisDiscrete-write}{\code{CFAxisDiscrete$write()}}
\item \href{#method-CFAxisDiscrete-clone}{\code{CFAxisDiscrete$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="peek"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-peek'><code>ncdfCF::CFAxis$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="shard"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-shard'><code>ncdfCF::CFAxis$shard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="time"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-time'><code>ncdfCF::CFAxis$time()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$new(grp, nc_var, nc_dim, orientation, dim_only = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grp}}{The group that contains the netCDF variable.}

\item{\code{nc_var}}{The netCDF variable that describes this instance.}

\item{\code{nc_dim}}{The netCDF dimension that describes the dimensionality.}

\item{\code{orientation}}{The orientation (\code{X}, \code{Y}, \code{Z}, or \code{T}) or \code{""} if
different or unknown.}

\item{\code{dim_only}}{Flag if this axis only has a dimension on file but no
NC variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-print"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-print}{}}}
\subsection{Method \code{print()}}{
Summary of the axis printed to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed on to other functions. Of particular interest
is \verb{width = } to indicate a maximum width of attribute columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-brief"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-brief}{}}}
\subsection{Method \code{brief()}}{
Some details of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$brief()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 1-row \code{data.frame} with some details of the axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-indexOf"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-indexOf}{}}}
\subsection{Method \code{indexOf()}}{
Find indices in the axis domain. Given a vector of numerical
values \code{x}, find their indices in the values of the axis. In effect,
this returns index values into the axis, but outside values will be
dropped.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$indexOf(x, method = "constant")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector of numeric values to find axis indices for.}

\item{\code{method}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Numeric vector of the same length as \code{x}. Values of \code{x} outside
of the range of the values in the axis are returned as \code{0} and
\code{.Machine$integer.max}, respectively.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-subset"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-subset}{}}}
\subsection{Method \code{subset()}}{
Return an axis spanning a smaller coordinate range. This
method returns an axis which spans the range of indices given by the
\code{rng} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$subset(group, rng = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{The group to create the new axis in.}

\item{\code{rng}}{The range of indices from this axis to include in the returned
axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{CFAxisDiscrete} instance covering the indicated range of
indices. If the \code{rng} argument includes only a single value, an
\link{CFAxisScalar} instance is returned with the value from this axis. If
the value of the argument is \code{NULL}, return the entire axis (possibly
as a scalar axis).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-write"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-write}{}}}
\subsection{Method \code{write()}}{
Write the axis to a netCDF file, including its attributes,
but only if it has an associated NC variable in the file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$write(nc = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nc}}{The handle of the netCDF file opened for writing or a group in
the netCDF file. If \code{NULL}, write to the file or group where the axis
was read from (the file must have been opened for writing). If not
\code{NULL}, the handle to a netCDF file or a group therein.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisDiscrete-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisDiscrete-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisDiscrete$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
