% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{plot.lisa}
\alias{plot.lisa}
\title{Plots local indicators of spatial association}
\usage{
\method{plot}{lisa}(x, neigh.mean = FALSE, add = FALSE, inches = 0.2,
  ...)
}
\arguments{
\item{x}{an object of class "lisa", usually, as a result of a call to \code{\link{lisa}}.}

\item{neigh.mean}{If TRUE, size of symbols represents average observation in each neighborhood; If FALSE, size of symbols represents the original observation}

\item{add}{If TRUE, a lisa-plot will be added to a pre-existing plot.}

\item{inches}{scales the size of the symbols}

\item{\dots}{other arguments}
}
\value{
A bubble-plot of observations against spatial coordinates is produced. Above mean values are signified by red circles. Below mean values are signified by black squares. 

  If a permutation test was performed, observations for which the associated LISA statistic is significant at a nominal (two-sided) 5\%-level will be represented by filled symbols and non-significant values by open symbols. Thus spatial hot-spots are represented by red filled circles and cold-spots by black filled squares.
}
\description{
`plot' method for class "lisa".
}
\seealso{
\code{\link{lisa}}, \code{\link{lisa.nc}}
}
\keyword{spatial}
