\name{plot.cv.ncvreg}
\alias{plot.cv.ncvreg}
\title{Plots the cross-validation curve from a cv.ncvreg object}
\description{Plots the cross-validation curve from a \code{cv.ncvreg} or
  \code{cv.ncvsurv} object, along with standard error bars.}
\usage{
\method{plot}{cv.ncvreg}(x, log.l=TRUE, type=c("cve", "rsq", "scale",
"snr", "pred", "all"), selected=TRUE, vertical.line=TRUE, col="red",
...) 
}
\arguments{
  \item{x}{A \code{cv.ncvreg} or \code{cv.ncvsurv} object.}
  \item{log.l}{Should horizontal axis be on the log scale?  Default is
    TRUE.}
  \item{type}{What to plot on the vertical axis.  \code{cve} plots the
    cross-validation error (deviance); \code{rsq} plots an estimate of
    the fraction of the deviance explained by the model (R-squared);
    \code{snr} plots an estimate of the signal-to-noise ratio;
    \code{scale} plots, for \code{family="gaussian"}, an estimate of the
    scale parameter (standard deviation); \code{pred} plots, for
    \code{family="binomial"}, the estimated prediction error; \code{all}
    produces all of the above.}
  \item{selected}{If \code{TRUE} (the default), places an axis on top of
    the plot denoting the number of variables in the model (i.e., that
    have a nonzero regression coefficient) at that value of
    \code{lambda}.}
  \item{vertical.line}{If \code{TRUE} (the default), draws a vertical
    line at the value where cross-validaton error is minimized.}
  \item{col}{Controls the color of the dots (CV estimates).}
  \item{\dots}{Other graphical parameters to \code{plot}}
}
\details{
  Error bars representing approximate 68\% confidence intervals are
  plotted along with the estimates at value of \code{lambda}.  For
  \code{rsq} and \code{snr} applied to models other than linear
  regression, the Cox-Snell R-squared is used.}
\references{
  Breheny P and Huang J. (2011) Coordinate descentalgorithms
  for nonconvex penalized regression, with applications to biological
  feature selection.  \emph{Annals of Applied Statistics}, \strong{5}:
  232-253.
  \doi{10.1214/10-AOAS388}
}
\author{Patrick Breheny}
\seealso{\code{\link{ncvreg}}, \code{\link{cv.ncvreg}}}
\examples{
# Linear regression --------------------------------------------------
data(Prostate)
cvfit <- cv.ncvreg(Prostate$X, Prostate$y)
plot(cvfit)
op <- par(mfrow=c(2,2))
plot(cvfit, type="all")
par(op)

# Logistic regression ------------------------------------------------
data(Heart)
cvfit <- cv.ncvreg(Heart$X, Heart$y, family="binomial")
plot(cvfit)
op <- par(mfrow=c(2,2))
plot(cvfit, type="all")
par(op)

# Cox regression -----------------------------------------------------
data(Lung)
cvfit <- cv.ncvsurv(Lung$X, Lung$y)
op <- par(mfrow=c(1,2))
plot(cvfit)
plot(cvfit, type="rsq")
par(op)
}
