% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{turnout}
\alias{turnout}
\title{Turnout}
\format{
a list of three fitted models:
\itemize{
\item group: the group-rule-utilitarian model,
\item intens: the intensity model,
\item sur: the reduced form SUR model.
}
}
\source{
\href{https://www.aeaweb.org/aer/}{American Economic Association data archive}.
}
\description{
these three models are replication in R of stata's
code available on the web site of the American Economic
Association. The estimation is complicated by the fact that
some linear constraints are imposed. The estimation was
performed using the \code{maxLik} package. As the Hessian is near
singular, the \code{bread} method for \code{maxLik} which use the \code{vcov}
method returns an error. Therefore, we use a new \code{maxLik2}
class and write specific \code{llcont}, \code{estfun} and \code{bread} methods
for this class.
}
\details{
Turnout in Texas liquor referenda
}
\examples{
\dontrun{
data("turnout", package = "ndvtest")
ndvtest(turnout$group, turnout$intens)
ndvtest(turnout$group, turnout$sur)
ndvtest(turnout$intens, turnout$sur)
}
}
\references{
\insertRef{COAT:CONL:04}{ndvtest}
}
\keyword{dataset}
