% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.twoindmeans.R
\name{neg.twoindmeans}
\alias{neg.twoindmeans}
\alias{print.neg.twoindmeans}
\title{Negligible Effect Test on the Difference between the Means of Independent Populations}
\usage{
neg.twoindmeans(
  v1 = NULL,
  v2 = NULL,
  dv = NULL,
  iv = NULL,
  eil,
  eiu,
  varequiv = FALSE,
  normality = FALSE,
  tr = 0.2,
  nboot = 500,
  alpha = 0.05,
  plot = TRUE,
  saveplot = FALSE,
  data = NULL
)

\method{print}{neg.twoindmeans}(x, ...)
}
\arguments{
\item{v1}{Data for Group 1 (if dv and iv are omitted)}

\item{v2}{Data for Group 2 (if dv and iv are omitted)}

\item{dv}{Dependent Variable (if v1 and v2 are omitted)}

\item{iv}{Dichotomous Predictor/Independent Variable (if v1 and v2 are omitted)}

\item{eil}{Lower Bound of the Equivalence Interval}

\item{eiu}{Upper Bound of the Equivalence Interval}

\item{varequiv}{Are the population variances assumed to be equal? Population variances are assumed to be unequal if normality=FALSE.}

\item{normality}{Are the population variances (and hence the residuals) assumed to be normally distributed?}

\item{tr}{Proportion of trimming from each tail (relevant if normality = FALSE)}

\item{nboot}{Number of bootstrap samples for calculating CIs}

\item{alpha}{Nominal Type I Error rate}

\item{plot}{Should a plot of the results be produced?}

\item{saveplot}{Should the plot be saved?}

\item{data}{Dataset containing v1/v2 or iv/dv}

\item{x}{object of class \code{neg.twoindmeans}}

\item{...}{extra arguments}
}
\value{
returns a \code{list} containing each analysis and their respective statistics
  and decision


}
\description{
This function allows researchers to test whether the difference
between the means of two independent populations is negligible, where
negligible represents the smallest meaningful effect size (MMES, which
in this case the effect is the mean difference)
}
\examples{
indvar<-rep(c("a","b"),c(10,12))
depvar<-rnorm(22)
d<-data.frame(indvar,depvar)
neg.twoindmeans(dv=depvar,iv=indvar,eil=-1,eiu=1,plot=TRUE,data=d)
neg.twoindmeans(dv=depvar,iv=indvar,eil=-1,eiu=1)
neg.twoindmeans(v1=depvar[indvar=="a"],v2=depvar[indvar=="b"],eil=-1,eiu=1)
xx<-neg.twoindmeans(dv=depvar,iv=indvar,eil=-1,eiu=1)
xx$decis
}
\author{
Rob Cribbie \email{cribbie@yorku.ca}
  R. Philip Chalmers \email{chalmrp@yorku.ca}
  Naomi Martinez Gutierrez \email{naomimg@yorku.ca}
}
