% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutuality.R
\name{mutuality}
\alias{mutuality}
\title{Mutuality mechanism}
\usage{
mutuality(X, actor)
}
\arguments{
\item{X}{Binary network; of class \code{matrix}.}

\item{actor}{A unit (actor; row/column number), which have an opportunity to change a link.}
}
\value{
A vector with the normalized mutuality mechanism, cacluated between the actor and other units.
}
\description{
Calculate the normalized network statistic according to the mutuality mechanism.
}
\examples{
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
mutuality(X, actor = 2)
}
\references{
\itemize{
\item Cugmas, M., Žiberna, A., & Ferligoj, A. (2019). Mechanisms generating asymmetric core-cohesive blockmodels. Advances in Methodology and Statistics, 16(1), 17-41.
\item Cugmas, M., & Žiberna, A. (2022). Approaches to blockmodeling dynamic networks: a Monte Carlo simulation study. Social Networks, in print.
}
}
\author{
Marjan Cugmas and Aleš Žiberna
}
