% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stroke_01.R
\name{stroke_01}
\alias{stroke_01}
\title{Stroke-01 Calculation}
\usage{
stroke_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  eresponse_05_col,
  esituation_11_col,
  esituation_12_col,
  evitals_23_col,
  evitals_26_col,
  evitals_29_col,
  evitals_30_col,
  confidence_interval = FALSE,
  method = c("wilson", "clopper-pearson"),
  conf.level = 0.95,
  correct = TRUE,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing the dataset. Each row should
represent a unique patient encounter.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data.frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{vitals_table}{A data.frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{The column containing unique record identifiers for
each encounter.}

\item{eresponse_05_col}{The column containing EMS response codes, which
should include 911 response codes.}

\item{esituation_11_col}{The column containing the primary impression codes
or descriptions related to the situation.}

\item{esituation_12_col}{The column containing secondary impression codes or
descriptions related to the situation.}

\item{evitals_23_col}{The column containing the Glasgow Coma Scale (GCS)
score.}

\item{evitals_26_col}{The column containing the AVPU (alert, verbal, pain,
unresponsive) scale value.}

\item{evitals_29_col}{The column containing the stroke scale score achieved
during assessment.}

\item{evitals_30_col}{The column containing stroke scale type descriptors
(e.g., FAST, NIH, etc.).}

\item{confidence_interval}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical. If
\code{TRUE}, the function calculates a confidence interval for the proportion
estimate.}

\item{method}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Character. Specifies the
method used to calculate confidence intervals. Options are \code{"wilson"}
(Wilson score interval) and \code{"clopper-pearson"} (exact binomial interval).
Partial matching is supported, so \code{"w"} and \code{"c"} can be used as shorthand.}

\item{conf.level}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Numeric. The confidence
level for the interval, expressed as a proportion (e.g., 0.95 for a 95\%
confidence interval). Defaults to 0.95.}

\item{correct}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Logical. If \code{TRUE},
applies a continuity correction to the Wilson score interval when \code{method = "wilson"}. Defaults to \code{TRUE}.}

\item{...}{optional additional arguments to pass onto \code{dplyr::summarize}.}
}
\value{
A data.frame summarizing results for two population groups (All,
Adults and Peds) with the following columns:
\itemize{
\item \code{pop}: Population type (All, Adults, and Peds).
\item \code{numerator}: Count of incidents meeting the measure.
\item \code{denominator}: Total count of included incidents.
\item \code{prop}: Proportion of incidents meeting the measure.
\item \code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
\item \code{lower_ci}: Lower bound of the confidence interval for \code{prop}
(if \code{confidence_interval = TRUE}).
\item \code{upper_ci}: Upper bound of the confidence interval for \code{prop}
(if \code{confidence_interval = TRUE}).
}
}
\description{
The \code{stroke_01} function processes EMS dataset to identify potential stroke
cases based on specific criteria and calculates the stroke scale measures. It
filters the data for 911 response calls, identifies stroke-related
impressions and scales, and aggregates results by unique patient encounters.
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    esituation_11 = c(rep("I60", 3), rep("I61", 2)),
    esituation_12 = c(rep("I63", 2), rep("I64", 3)),
    evitals_23 = c(16, 15, 14, 13, 12),
    evitals_26 = c("Alert", "Painful", "Verbal", "Unresponsive", "Alert"),
    evitals_29 = rep("positive", 5),
    evitals_30 = rep("a pain scale", 5)
  )

# Run the function
# Return 95\% confidence intervals using the Wilson method
  stroke_01(
    df = test_data,
    erecord_01_col = erecord_01,
    eresponse_05_col = eresponse_05,
    esituation_11_col = esituation_11,
    esituation_12_col = esituation_12,
    evitals_23_col = evitals_23,
    evitals_26_col = evitals_26,
    evitals_29_col = evitals_29,
    evitals_30_col = evitals_30,
    confidence_interval = TRUE
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
