% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_store.R
\name{neon_store}
\alias{neon_store}
\title{Show tables that have been downloaded to the neon store}
\usage{
neon_store(
  product = NA,
  table = NA,
  site = NA,
  start_date = NA,
  end_date = NA,
  ext = NA,
  hash = NULL,
  dir = neon_dir()
)
}
\arguments{
\item{product}{Include only files matching this NEON productCode(s)}

\item{table}{Include only files matching this table name (or regex pattern).
(optional).}

\item{site}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}

\item{start_date}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}

\item{end_date}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}

\item{ext}{only match files with this file extension(s)}

\item{hash}{name of a hashing algorithm to check file integrity. Can be
\code{"md5"}, \code{"sha1"}, or \code{"sha256"} currently; or set to \link{NULL} (default)
to skip hash computation.}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}
}
\description{
Show tables that have been downloaded to the neon store
}
\details{
The table names displayed can be read in using \link{neon_read}.
Optionally, specify a NEON productCode to view only tables associated
with a specific product.

Only downloaded tables will be displayed.  Users can view all available
NEON data products using \link{neon_products} to choose which ones to download
into the store.

\code{neon_store()} does not need to access the API and thus does not require
an internet connection or incur rate limiting on requests.
}
\examples{

neon_store()


}
\seealso{
\link{neon_products}, \link{neon_download}, \link{neon_index}
}
