% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geochron.R
\name{get_geochron}
\alias{get_geochron}
\title{Function to return geochronological data from records.}
\usage{
get_geochron(x, verbose = TRUE)
}
\arguments{
\item{x}{A numeric dataset ID or a vector of numeric dataset IDs, or an object of class of class \code{site}, \code{dataset}, \code{dataset_list}, \code{download} or \code{download_list} for which geochrons are required.}

\item{verbose}{logical; should messages on API call be printed?}
}
\value{
This command returns either an object of class \code{"try-error"}' (see \code{\link{try}}) definined by the error returned
   from the Neotoma API call, or a \code{geochronologic} object, which is a list with two components, a \code{dataset} and a geochronology table, a \code{data.frame} with the following components:

 \item{ \code{sample.id} }{A unique identifier for the geochronological unit.}
 \item{ \code{age.type} }{String.  The age type, one of calendar years, radiocarbon years, etc.}
 \item{ \code{age} }{Dated age of the material.}
 \item{ \code{e.older} }{The older error limit of the age value.  Commonly 1 standard deviation.}
 \item{ \code{e.young} }{The younger error limit of the age value.}
 \item{ \code{delta13C} }{The measured or assumed delta13C value for radiocarbon dates, if provided.}
 \item{ \code{material.dated} }{A table describing the collection, including dataset information, PI data compatable with \code{\link{get_contact}} and site data compatable with \code{\link{get_site}}.}
 \item{ \code{geo.chron.type} }{Text string, type of geochronological analysis, i.e., Radiocarbon dating, luminesence.}
 \item{ \code{notes} }{Text string}
 \item{ \code{infinite} }{Boolean, does the dated material return an "infinte" date?}

 A full data object containing all the relevant geochronological data available for a dataset.
}
\description{
Using the dataset ID, return all geochronological data associated with the dataID.  At present,
   only returns the dataset in an unparsed format, not as a data table.   This function will only download one dataset at a time.
}
\examples{
\dontrun{
#  Search for the sites around Marion Lake, BC.  I want to find sites within about 1km.

marion <- get_site(sitename = "Marion Lake*")

marion_close <- get_closest(marion, n = 10, buffer = 1)

#  Returns 116 records (as of 13/07/2015).  These are the pollen records though, we want the sites:
geochron.records <- get_geochron(marion_close)

#  We want to extract all the radiocarbon ages from the records:

get_ages <- function(x){
  any.ages <- try(x[[2]]$age[x[[2]]$age.type == 'Radiocarbon years BP'])
  if(class(any.ages) == 'try-error') output <- NA
  if(!class(any.ages) == 'try-error') output <- unlist(any.ages)
  output
}

radio.chron <- unlist(sapply(geochron.records, get_ages))

hist(radio.chron[radio.chron<40000], breaks=seq(0, 25000, by = 1000),
     main = 'Radiocarbon dates for Pseudotsuga records',
     xlab = 'Radiocarbon date (14C years before 1950)')
}

}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
API Reference:  http://api.neotomadb.org/doc/resources/contacts
}
\keyword{IO}
\keyword{connection}

